/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.async;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import org.infinispan.commons.CacheException;
import org.infinispan.persistence.modifications.Clear;
import org.infinispan.persistence.modifications.Modification;
import org.infinispan.persistence.modifications.ModificationsList;
import org.infinispan.persistence.modifications.Remove;
import org.infinispan.persistence.modifications.Store;

public class State {
    static final Clear CLEAR = new Clear();
    final boolean clear;
    final ConcurrentMap<Object, Modification> modifications;
    volatile State next;
    volatile boolean stopped = false;
    CountDownLatch workerThreads;

    State(boolean clear, ConcurrentMap<Object, Modification> modMap, State next) {
        this.clear = clear;
        this.modifications = modMap;
        this.next = next;
        if (next != null) {
            this.stopped = next.stopped;
        }
    }

    Modification get(Object key) {
        State state = this;
        while (state != null) {
            Modification mod = (Modification)state.modifications.get(key);
            if (mod != null) {
                return mod;
            }
            if (state.clear) {
                return CLEAR;
            }
            state = state.next;
        }
        return null;
    }

    void put(Modification mod) {
        if (this.stopped) {
            throw new CacheException("AsyncCacheWriter stopped; no longer accepting more entries.");
        }
        switch (mod.getType()) {
            case STORE: {
                this.modifications.put(((Store)mod).getKey(), mod);
                break;
            }
            case REMOVE: {
                this.modifications.put(((Remove)mod).getKey(), mod);
                break;
            }
            case LIST: {
                for (Modification modification : ((ModificationsList)mod).getList()) {
                    this.put(modification);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown modification type " + (Object)((Object)mod.getType()));
            }
        }
    }

    public Set getKeysInTransit() {
        HashSet result = new HashSet();
        this._loadKeys(this, result);
        return result;
    }

    private void _loadKeys(State s, Set result) {
        State next;
        if (!s.clear && (next = s.next) != null) {
            this._loadKeys(next, result);
        }
        for (Modification mod : s.modifications.values()) {
            switch (mod.getType()) {
                case STORE: {
                    Object key = ((Store)mod).getKey();
                    result.add(key);
                    break;
                }
                case REMOVE: {
                    result.remove(((Remove)mod).getKey());
                }
            }
        }
    }
}

