/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.sasl.SASLAnonymous;
import org.jivesoftware.smack.sasl.SASLCramMD5Mechanism;
import org.jivesoftware.smack.sasl.SASLDigestMD5Mechanism;
import org.jivesoftware.smack.sasl.SASLErrorException;
import org.jivesoftware.smack.sasl.SASLExternalMechanism;
import org.jivesoftware.smack.sasl.SASLGSSAPIMechanism;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.sasl.SASLPlainMechanism;

public class SASLAuthentication {
    private static Map<String, Class<? extends SASLMechanism>> implementedMechanisms = new HashMap<String, Class<? extends SASLMechanism>>();
    private static List<String> mechanismsPreferences = new ArrayList<String>();
    private XMPPConnection connection;
    private Collection<String> serverMechanisms = new ArrayList<String>();
    private SASLMechanism currentMechanism = null;
    private boolean saslNegotiated;
    private SASLMechanism.SASLFailure saslFailure;

    public static void registerSASLMechanism(String name, Class<? extends SASLMechanism> mClass) {
        implementedMechanisms.put(name, mClass);
    }

    public static void unregisterSASLMechanism(String name) {
        implementedMechanisms.remove(name);
        mechanismsPreferences.remove(name);
    }

    public static void supportSASLMechanism(String name) {
        mechanismsPreferences.add(0, name);
    }

    public static void supportSASLMechanism(String name, int index) {
        mechanismsPreferences.add(index, name);
    }

    public static void unsupportSASLMechanism(String name) {
        mechanismsPreferences.remove(name);
    }

    public static List<Class<? extends SASLMechanism>> getRegisterSASLMechanisms() {
        ArrayList<Class<? extends SASLMechanism>> answer = new ArrayList<Class<? extends SASLMechanism>>();
        for (String mechanismsPreference : mechanismsPreferences) {
            answer.add(implementedMechanisms.get(mechanismsPreference));
        }
        return answer;
    }

    SASLAuthentication(XMPPConnection connection) {
        this.connection = connection;
        this.init();
    }

    public boolean hasAnonymousAuthentication() {
        return this.serverMechanisms.contains("ANONYMOUS");
    }

    public boolean hasNonAnonymousAuthentication() {
        return !this.serverMechanisms.isEmpty() && (this.serverMechanisms.size() != 1 || !this.hasAnonymousAuthentication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(String resource, CallbackHandler cbh) throws IOException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SASLErrorException, SmackException.ResourceBindingNotOfferedException, SmackException.NotConnectedException {
        String selectedMechanism = null;
        for (String mechanism : mechanismsPreferences) {
            if (!implementedMechanisms.containsKey(mechanism) || !this.serverMechanisms.contains(mechanism)) continue;
            selectedMechanism = mechanism;
            break;
        }
        if (selectedMechanism != null) {
            Class<? extends SASLMechanism> mechanismClass = implementedMechanisms.get(selectedMechanism);
            try {
                Constructor<? extends SASLMechanism> constructor = mechanismClass.getConstructor(SASLAuthentication.class);
                this.currentMechanism = constructor.newInstance(this);
            }
            catch (Exception e) {
                throw new SaslException("Exception when creating the SASLAuthentication instance", e);
            }
            SASLAuthentication sASLAuthentication = this;
            synchronized (sASLAuthentication) {
                this.currentMechanism.authenticate(this.connection.getHost(), cbh);
                try {
                    this.wait(this.connection.getPacketReplyTimeout());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.saslFailure != null) {
                throw new SASLErrorException(selectedMechanism, this.saslFailure);
            }
            if (!this.saslNegotiated) {
                throw new SmackException.NoResponseException();
            }
        } else {
            throw new SaslException("SASL Authentication failed. No known authentication mechanisims.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(String username, String password, String resource) throws XMPPException.XMPPErrorException, SASLErrorException, SaslException, IOException, SmackException {
        String selectedMechanism = null;
        for (String mechanism : mechanismsPreferences) {
            if (!implementedMechanisms.containsKey(mechanism) || !this.serverMechanisms.contains(mechanism)) continue;
            selectedMechanism = mechanism;
            break;
        }
        if (selectedMechanism != null) {
            Class<? extends SASLMechanism> mechanismClass = implementedMechanisms.get(selectedMechanism);
            try {
                Constructor<? extends SASLMechanism> constructor = mechanismClass.getConstructor(SASLAuthentication.class);
                this.currentMechanism = constructor.newInstance(this);
            }
            catch (Exception e) {
                throw new SaslException("Exception when creating the SASLAuthentication instance", e);
            }
            SASLAuthentication sASLAuthentication = this;
            synchronized (sASLAuthentication) {
                String serviceName = this.connection.getServiceName();
                this.currentMechanism.authenticate(username, this.connection.getHost(), serviceName, password);
                try {
                    this.wait(this.connection.getPacketReplyTimeout());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.saslFailure != null) {
                throw new SASLErrorException(selectedMechanism, this.saslFailure);
            }
            if (!this.saslNegotiated) {
                throw new SmackException.NoResponseException();
            }
        } else {
            throw new SaslException("SASL Authentication failed. No known authentication mechanisims.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticateAnonymously() throws SASLErrorException, SaslException, IOException, SmackException, XMPPException.XMPPErrorException {
        this.currentMechanism = new SASLAnonymous(this);
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.currentMechanism.authenticate(null, null, null, "");
            try {
                this.wait(this.connection.getPacketReplyTimeout());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.saslFailure != null) {
            throw new SASLErrorException(this.currentMechanism.toString(), this.saslFailure);
        }
        if (!this.saslNegotiated) {
            throw new SmackException.NoResponseException();
        }
    }

    public void setAvailableSASLMethods(Collection<String> mechanisms) {
        this.serverMechanisms = mechanisms;
    }

    public boolean isAuthenticated() {
        return this.saslNegotiated;
    }

    public void challengeReceived(String challenge) throws IOException, SmackException.NotConnectedException {
        this.currentMechanism.challengeReceived(challenge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticated() {
        this.saslNegotiated = true;
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticationFailed(SASLMechanism.SASLFailure saslFailure) {
        this.saslFailure = saslFailure;
        SASLAuthentication sASLAuthentication = this;
        synchronized (sASLAuthentication) {
            this.notify();
        }
    }

    public void send(Packet stanza) throws SmackException.NotConnectedException {
        this.connection.sendPacket(stanza);
    }

    protected void init() {
        this.saslNegotiated = false;
        this.saslFailure = null;
    }

    static {
        SASLAuthentication.registerSASLMechanism("EXTERNAL", SASLExternalMechanism.class);
        SASLAuthentication.registerSASLMechanism("GSSAPI", SASLGSSAPIMechanism.class);
        SASLAuthentication.registerSASLMechanism("DIGEST-MD5", SASLDigestMD5Mechanism.class);
        SASLAuthentication.registerSASLMechanism("CRAM-MD5", SASLCramMD5Mechanism.class);
        SASLAuthentication.registerSASLMechanism("PLAIN", SASLPlainMechanism.class);
        SASLAuthentication.registerSASLMechanism("ANONYMOUS", SASLAnonymous.class);
        SASLAuthentication.supportSASLMechanism("GSSAPI", 0);
        SASLAuthentication.supportSASLMechanism("DIGEST-MD5", 1);
        SASLAuthentication.supportSASLMechanism("CRAM-MD5", 2);
        SASLAuthentication.supportSASLMechanism("PLAIN", 3);
        SASLAuthentication.supportSASLMechanism("ANONYMOUS", 4);
    }
}

