/*
 * Decompiled with CFR 0.152.
 */
package org.marre.wap.push;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.marre.mime.MimeBodyPart;
import org.marre.mime.MimeContentType;
import org.marre.sms.SmsPortAddressedMessage;
import org.marre.sms.SmsUserData;
import org.marre.wap.WapMimeEncoder;
import org.marre.wap.WspUtil;
import org.marre.wap.wbxml.WbxmlDocument;

public class SmsWapPushMessage
extends SmsPortAddressedMessage {
    protected byte myWspEncodingVersion = (byte)18;
    protected MimeBodyPart myPushMsg;

    protected SmsWapPushMessage() {
        super(2948, 9200);
    }

    public SmsWapPushMessage(MimeBodyPart thePushMsg) {
        this();
        this.myPushMsg = thePushMsg;
    }

    public SmsWapPushMessage(WbxmlDocument thePushMsg, MimeContentType theContentType) {
        this();
        theContentType.setParam("charset", "utf-8");
        this.myPushMsg = new MimeBodyPart(this.buildPushMessage(thePushMsg), theContentType);
    }

    public SmsWapPushMessage(WbxmlDocument thePushMsg, String theContentType) {
        this();
        MimeContentType ct = new MimeContentType(theContentType);
        ct.setParam("charset", "utf-8");
        this.myPushMsg = new MimeBodyPart(this.buildPushMessage(thePushMsg), ct);
    }

    public SmsWapPushMessage(WbxmlDocument thePushMsg) {
        this(thePushMsg, thePushMsg.getWbxmlContentType());
    }

    public SmsWapPushMessage(byte[] thePushMsg, MimeContentType theContentType) {
        this();
        this.myPushMsg = new MimeBodyPart(thePushMsg, theContentType);
    }

    public SmsWapPushMessage(byte[] thePushMsg, String theContentType) {
        this();
        this.myPushMsg = new MimeBodyPart(thePushMsg, theContentType);
    }

    protected byte[] buildPushMessage(WbxmlDocument thePushMsg) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            thePushMsg.writeXmlTo(thePushMsg.getWbxmlWriter(baos));
            baos.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return baos.toByteArray();
    }

    public void setWspEncodingVersion(byte wspEncodingVersion) {
        this.myWspEncodingVersion = wspEncodingVersion;
    }

    public SmsUserData getUserData() {
        WapMimeEncoder wapMimeEncoder = new WapMimeEncoder(18);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            WspUtil.writeUint8(baos, 0);
            WspUtil.writeUint8(baos, 6);
            ByteArrayOutputStream headers = new ByteArrayOutputStream();
            wapMimeEncoder.writeContentType(headers, this.myPushMsg);
            wapMimeEncoder.writeHeaders(headers, this.myPushMsg);
            headers.close();
            WspUtil.writeUintvar(baos, headers.size());
            baos.write(headers.toByteArray());
            wapMimeEncoder.writeBody(baos, this.myPushMsg);
            baos.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return new SmsUserData(baos.toByteArray());
    }

    public void setXWapApplicationId(String appId) {
        this.myPushMsg.addHeader("X-Wap-Application-Id", appId);
    }

    public void setXWapContentURI(String contentUri) {
        this.myPushMsg.addHeader("X-Wap-Content-URI", contentUri);
    }

    public void setXWapInitiatorURI(String initiatorUri) {
        this.myPushMsg.addHeader("X-Wap-Initiator-URI", initiatorUri);
    }
}

