/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.transport.ucp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import org.marre.sms.SmsAddress;
import org.marre.sms.SmsException;
import org.marre.sms.SmsMessage;
import org.marre.sms.SmsPdu;
import org.marre.sms.SmsPduUtil;
import org.marre.sms.transport.SmsTransport;
import org.marre.sms.transport.ucp.UCPSeries60;
import org.marre.sms.transport.ucp.UcpSeries50;
import org.marre.util.StringUtil;

public class UcpTransport
implements SmsTransport {
    private String ucpServerName_;
    private int ucpServerPort_;
    private String ucp60Uid_;
    private String ucp60Pwd_;
    private boolean doUcp60Login_;
    private Socket ucpSocket_;
    private DataOutputStream ucpOs_;
    private DataInputStream ucpIs_;

    public void init(Properties props) throws SmsException {
        this.ucpServerName_ = props.getProperty("smsj.ucp.ip.host");
        this.ucpServerPort_ = Integer.parseInt(props.getProperty("smsj.ucp.ip.port"));
        this.ucp60Uid_ = props.getProperty("smsj.ucp.ucp60.uid");
        this.ucp60Pwd_ = props.getProperty("smsj.ucp.ucp60.password");
        if (this.ucp60Uid_ == null || this.ucp60Pwd_ == null) {
            this.doUcp60Login_ = false;
        } else {
            if ("".equals(this.ucp60Uid_)) {
                throw new SmsException("UCP Transport: empty UCP60 username");
            }
            this.doUcp60Login_ = true;
        }
    }

    public void connect() throws SmsException, IOException {
        this.ucpSocket_ = new Socket(this.ucpServerName_, this.ucpServerPort_);
        this.ucpOs_ = new DataOutputStream(this.ucpSocket_.getOutputStream());
        this.ucpIs_ = new DataInputStream(this.ucpSocket_.getInputStream());
        if (this.doUcp60Login_) {
            byte[] loginCmd = this.buildLogin(this.ucp60Uid_, this.ucp60Pwd_);
            String response = this.sendUcp(loginCmd);
            System.err.println("SMSC response: " + response);
        }
    }

    public String send(SmsMessage msg, SmsAddress theDest, SmsAddress sender) throws SmsException, IOException {
        SmsPdu[] msgPdu = null;
        if (theDest.getTypeOfNumber() == 5) {
            throw new SmsException("Cannot sent SMS to ALPHANUMERIC address");
        }
        msgPdu = msg.getPdus();
        for (int i = 0; i < msgPdu.length; ++i) {
            boolean moreToSend = i < msgPdu.length - 1;
            byte[] submitCmd = this.buildSubmit(msgPdu[i], moreToSend, theDest, sender);
            String response = this.sendUcp(submitCmd);
            System.err.println("SMSC response: " + response);
        }
        return null;
    }

    public byte[] buildLogin(String userid, String pwd) throws SmsException {
        UCPSeries60 ucplogin = new UCPSeries60(60);
        ucplogin.setTRN(1);
        ucplogin.setField(0, userid);
        ucplogin.setField(1, "6");
        ucplogin.setField(2, "5");
        ucplogin.setField(3, "1");
        ucplogin.setField(6, "0100");
        ucplogin.setField(4, StringUtil.bytesToHexString(SmsPduUtil.toGsmCharset(pwd)));
        return ucplogin.getCommand();
    }

    public byte[] buildSubmit(SmsPdu pdu, boolean moreToSend, SmsAddress dest, SmsAddress sender) throws SmsException {
        UcpSeries50 ucpSubmit;
        block15: {
            boolean isSeptets;
            block14: {
                ucpSubmit = new UcpSeries50(51);
                byte[] udh = pdu.getUserDataHeaders();
                isSeptets = pdu.getDcs().getAlphabet() == 0;
                ucpSubmit.setTRN(1);
                if (sender.getTypeOfNumber() == 5) {
                    String addr = sender.getAddress();
                    if (addr.length() > 11) {
                        throw new SmsException("Max alphanumeric Originator Address Code length exceded (11)");
                    }
                    String codedaddr = StringUtil.bytesToHexString(SmsPduUtil.getSeptets(addr));
                    int x = codedaddr.length();
                    StringBuffer sb = new StringBuffer("00");
                    sb.replace(2 - Integer.toHexString(x).toUpperCase().length(), 2, Integer.toHexString(x).toUpperCase());
                    ucpSubmit.setField(1, sb.toString().concat(codedaddr));
                    ucpSubmit.setField(28, "5039");
                } else {
                    ucpSubmit.setField(28, "1139");
                    ucpSubmit.setField(1, sender.getAddress());
                }
                ucpSubmit.setField(0, dest.getAddress());
                if (pdu.getUserDataHeaders() != null) break block14;
                switch (pdu.getDcs().getAlphabet()) {
                    case 0: {
                        System.out.println("GSM Message without UDH");
                        ucpSubmit.setField(18, "3");
                        String msg = SmsPduUtil.readSeptets(pdu.getUserData().getData(), pdu.getUserData().getLength());
                        ucpSubmit.setField(20, StringUtil.bytesToHexString(SmsPduUtil.toGsmCharset(msg)));
                        System.out.println(msg.length());
                        break block15;
                    }
                    case 1: {
                        throw new SmsException(" 8Bit Messages without UDH are not Supported");
                    }
                    case 2: {
                        System.out.println("UCS2 Message without UDH");
                        String ud = StringUtil.bytesToHexString(pdu.getUserData().getData());
                        ucpSubmit.setField(20, ud);
                        int udBits = pdu.getUserData().getLength() * (isSeptets ? 7 : 8);
                        ucpSubmit.setField(19, StringUtil.intToString(udBits, 4));
                        ucpSubmit.setField(18, "4");
                        ucpSubmit.clearXSer();
                        ucpSubmit.addXSer((byte)2, pdu.getDcs().getValue());
                        break block15;
                    }
                    default: {
                        throw new SmsException("Unsupported data coding scheme");
                    }
                }
            }
            switch (pdu.getDcs().getAlphabet()) {
                case 0: {
                    throw new SmsException("Cannot send 7 bit encoded messages with UDH");
                }
                case 1: {
                    String ud = StringUtil.bytesToHexString(pdu.getUserData().getData());
                    byte[] udhData = pdu.getUserDataHeaders();
                    String udhStr = StringUtil.bytesToHexString(new byte[]{(byte)udhData.length});
                    udhStr = udhStr + StringUtil.bytesToHexString(udhData);
                    ucpSubmit.setField(20, ud);
                    int udBits = pdu.getUserData().getLength() * (isSeptets ? 7 : 8);
                    ucpSubmit.setField(19, StringUtil.intToString(udBits, 4));
                    ucpSubmit.setField(18, "4");
                    ucpSubmit.clearXSer();
                    ucpSubmit.addXSer((byte)2, pdu.getDcs().getValue());
                    ucpSubmit.addXSer((byte)1, udhData);
                    break;
                }
                case 2: {
                    throw new SmsException(" UCS2 Messages are currently not Supportet ");
                }
                default: {
                    throw new SmsException("Unsupported data coding scheme");
                }
            }
        }
        if (moreToSend) {
            ucpSubmit.setField(21, "1");
        }
        return ucpSubmit.getCommand();
    }

    public void ping() throws SmsException {
    }

    public void disconnect() throws SmsException, IOException {
        this.ucpOs_.close();
        this.ucpIs_.close();
        this.ucpSocket_.close();
    }

    public String sendUcp(byte[] data) throws SmsException, IOException {
        if (!this.ucpSocket_.isConnected() || this.ucpOs_ == null || this.ucpIs_ == null) {
            throw new SmsException("Please Connect first");
        }
        System.out.println("SMSC send: " + new String(data, 0, data.length));
        this.ucpOs_.write(data);
        this.ucpOs_.flush();
        byte[] b = new byte[]{this.ucpIs_.readByte()};
        if (b[0] != 2) {
            System.out.println("SendSMS.send: The SMSC sends a bad reply");
            throw new SmsException("The SMSC sends a bad reply");
        }
        StringBuffer strBuf = new StringBuffer();
        while ((b[0] = this.ucpIs_.readByte()) != 3) {
            strBuf.append(new String(b));
        }
        return strBuf.toString();
    }
}

