/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.transport.gsm.commands;

import java.io.IOException;
import org.marre.sms.transport.gsm.GsmComm;
import org.marre.sms.transport.gsm.GsmException;
import org.marre.sms.transport.gsm.commands.PduSendMessageRsp;
import org.marre.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PduSendMessageReq {
    private static Logger log_ = LoggerFactory.getLogger((Class)(class$org$marre$sms$transport$gsm$commands$PduSendMessageReq == null ? (class$org$marre$sms$transport$gsm$commands$PduSendMessageReq = PduSendMessageReq.class$("org.marre.sms.transport.gsm.commands.PduSendMessageReq")) : class$org$marre$sms$transport$gsm$commands$PduSendMessageReq));
    private byte[] smscPdu_;
    private byte[] smsPdu_;
    static /* synthetic */ Class class$org$marre$sms$transport$gsm$commands$PduSendMessageReq;

    public PduSendMessageReq(byte[] smsPdu) {
        this.smscPdu_ = new byte[]{0};
        this.smsPdu_ = smsPdu;
    }

    public PduSendMessageReq(byte[] smscPdu, byte[] smsPdu) {
        this.smscPdu_ = smscPdu;
        this.smsPdu_ = smsPdu;
    }

    public PduSendMessageRsp send(GsmComm comm) throws GsmException, IOException {
        log_.debug("Sending AT+CMGS command");
        comm.send("AT+CMGS=" + this.smsPdu_.length + "\r");
        log_.debug("Read response from AT+CMGS command. Expecting a single '> ' without crlf.");
        this.readContinue(comm);
        String cmgsPduString = StringUtil.bytesToHexString(this.smscPdu_) + StringUtil.bytesToHexString(this.smsPdu_);
        log_.debug("Send hexcoded PDU.");
        comm.send(cmgsPduString + "\u001a");
        return this.readResponse(comm);
    }

    private PduSendMessageRsp readResponse(GsmComm comm) throws GsmException, IOException {
        String response = comm.readLine();
        if (response.startsWith("+CMGS")) {
            return new PduSendMessageRsp(null);
        }
        if (response.startsWith("+CMS ERROR:")) {
            throw new GsmException("CMS ERROR", response);
        }
        throw new GsmException("Unexpected response", response);
    }

    private void readContinue(GsmComm comm) throws GsmException, IOException {
        String response = comm.readLine("> ");
        if (!response.equals("> ")) {
            throw new GsmException("Unexpected response", response);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

