/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.transport.gsm;

import java.io.IOException;
import java.util.Properties;
import org.marre.sms.SmsAddress;
import org.marre.sms.SmsException;
import org.marre.sms.SmsMessage;
import org.marre.sms.SmsPdu;
import org.marre.sms.transport.SmsTransport;
import org.marre.sms.transport.gsm.GsmEncoder;
import org.marre.sms.transport.gsm.GsmException;
import org.marre.sms.transport.gsm.SerialComm;
import org.marre.sms.transport.gsm.commands.MessageFormatSetReq;
import org.marre.sms.transport.gsm.commands.PduSendMessageReq;
import org.marre.sms.transport.gsm.commands.PduSendMessageRsp;
import org.marre.sms.transport.gsm.commands.PingReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsmTransport
implements SmsTransport {
    private static Logger log_ = LoggerFactory.getLogger((Class)(class$org$marre$sms$transport$gsm$SerialComm == null ? (class$org$marre$sms$transport$gsm$SerialComm = GsmTransport.class$("org.marre.sms.transport.gsm.SerialComm")) : class$org$marre$sms$transport$gsm$SerialComm));
    private static String DEFAULT_SERIAL_PORT_APP_NAME = "SMSJ";
    private static final int RESPONSE_OK = 1;
    private static final int RESPONSE_ERROR = 2;
    private static final int RESPONSE_EMPTY_LINE = 4;
    private static final int RESPONSE_TEXT = 8;
    private static final int RESPONSE_CONTINUE = 16;
    private SerialComm serialComm_ = null;
    static /* synthetic */ Class class$org$marre$sms$transport$gsm$SerialComm;

    public void init(Properties props) {
        String appName = props.getProperty("sms.gsm.appname", DEFAULT_SERIAL_PORT_APP_NAME);
        String portName = props.getProperty("sms.gsm.serialport", "COM1");
        this.serialComm_ = new SerialComm(appName, portName);
        this.serialComm_.setBitRate(props.getProperty("sms.gsm.bitrate", "19200"));
        this.serialComm_.setDataBits(props.getProperty("sms.gsm.bit", "8"));
        this.serialComm_.setStopBits(props.getProperty("sms.gsm.stopbits", "8"));
        this.serialComm_.setParity(props.getProperty("sms.gsm.parity", "NONE"));
        this.serialComm_.setFlowControl(props.getProperty("sms.gsm.flowcontrol", "NONE"));
        this.serialComm_.setEcho(props.getProperty("sms.gsm.echo", "1").equals("1"));
    }

    public void connect() throws SmsException, IOException {
        try {
            log_.debug("Open serial port.");
            this.serialComm_.open();
            log_.debug("Serial port opened.");
            MessageFormatSetReq messageFormatSetReq = new MessageFormatSetReq(0);
            messageFormatSetReq.send(this.serialComm_);
        }
        catch (GsmException e) {
            log_.debug("Close serial port.");
            this.serialComm_.close();
            log_.debug("Serial port closed.");
            throw new SmsException("Connect failed: " + e.getMessage() + " Last response:" + e.getResponse(), e);
        }
    }

    public String send(SmsMessage msg, SmsAddress dest, SmsAddress sender) throws SmsException, IOException {
        if (dest.getTypeOfNumber() == 5) {
            throw new SmsException("Cannot sent SMS to an ALPHANUMERIC address");
        }
        try {
            SmsPdu[] msgPdu = msg.getPdus();
            for (int i = 0; i < msgPdu.length; ++i) {
                byte[] data = GsmEncoder.encodePdu(msgPdu[i], dest, sender);
                PduSendMessageReq sendMessageReq = new PduSendMessageReq(data);
                PduSendMessageRsp sendMessageRsp = sendMessageReq.send(this.serialComm_);
            }
        }
        catch (GsmException e) {
            throw new SmsException("Send failed: " + e.getMessage() + " Last response:" + e.getResponse(), e);
        }
        return null;
    }

    public void ping() throws IOException {
        try {
            PingReq pingReq = new PingReq();
            pingReq.send(this.serialComm_);
        }
        catch (GsmException e) {
            String msg = "Ping failed: " + e.getMessage() + " Last response: " + e.getResponse();
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    public void disconnect() {
        this.serialComm_.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

