/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.transport.gsm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.marre.sms.SmsAddress;
import org.marre.sms.SmsException;
import org.marre.sms.SmsPdu;
import org.marre.sms.SmsPduUtil;
import org.marre.sms.SmsUserData;

public final class GsmEncoder {
    private GsmEncoder() {
    }

    public static byte[] encodePdu(SmsPdu thePdu, SmsAddress theDestination, SmsAddress theSender) throws SmsException {
        if (thePdu.getDcs().getAlphabet() == 0) {
            return GsmEncoder.encodeSeptetPdu(thePdu, theDestination, theSender);
        }
        return GsmEncoder.encodeOctetPdu(thePdu, theDestination, theSender);
    }

    private static byte[] encodeSeptetPdu(SmsPdu thePdu, SmsAddress theDestination, SmsAddress theSender) throws SmsException {
        SmsUserData userData = thePdu.getUserData();
        byte[] ud = userData.getData();
        byte[] udh = thePdu.getUserDataHeaders();
        int nUdSeptets = userData.getLength();
        int nUdBits = 0;
        int nUdhBytes = udh == null ? 0 : udh.length;
        int nUdhBits = 0;
        int nTotalBytes = 0;
        int nTotalBits = 0;
        int nTotalSeptets = 0;
        int nFillBits = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(161);
        try {
            if (nUdhBytes == 0) {
                baos.write(1);
            } else {
                nUdhBits = nUdhBytes * 8;
                if (nUdhBits % 7 > 0) {
                    nFillBits = 7 - nUdhBits % 7;
                }
                baos.write(65);
            }
            nUdBits = nUdSeptets * 7;
            nTotalBits = nUdBits + nFillBits + nUdhBits;
            nTotalSeptets = nTotalBits / 7;
            nTotalBytes = nTotalBits / 8;
            if (nTotalBits % 8 > 0) {
                ++nTotalBytes;
            }
            baos.write(0);
            GsmEncoder.writeDestinationAddress(baos, theDestination);
            baos.write(0);
            baos.write(thePdu.getDcs().getValue());
            if (udh == null || udh.length == 0) {
                baos.write(nUdSeptets);
                baos.write(ud);
            } else {
                byte[] fullUd = new byte[nTotalBytes];
                baos.write(nTotalSeptets);
                System.arraycopy(udh, 0, fullUd, 0, nUdhBytes);
                SmsPduUtil.arrayCopy(ud, 0, fullUd, nUdhBytes, nFillBits, nUdBits);
                baos.write(fullUd);
            }
            baos.close();
        }
        catch (IOException ex) {
            throw new SmsException(ex);
        }
        return baos.toByteArray();
    }

    private static byte[] encodeOctetPdu(SmsPdu thePdu, SmsAddress theDestination, SmsAddress theSender) throws SmsException {
        SmsUserData userData = thePdu.getUserData();
        byte[] ud = userData.getData();
        byte[] udh = thePdu.getUserDataHeaders();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(200);
        try {
            int nUdBytes = userData.getLength();
            int nUdhBytes = udh == null ? 0 : udh.length;
            int tpUdl = nUdBytes + nUdhBytes + 1;
            if (nUdhBytes == 0) {
                baos.write(1);
            } else {
                baos.write(65);
            }
            baos.write(0);
            GsmEncoder.writeDestinationAddress(baos, theDestination);
            baos.write(0);
            baos.write(thePdu.getDcs().getValue());
            if (nUdhBytes == 0) {
                baos.write(nUdBytes);
                baos.write(ud);
            } else {
                byte[] fullUd = new byte[nUdBytes + nUdhBytes];
                baos.write(nUdBytes + nUdhBytes);
                System.arraycopy(udh, 0, fullUd, 0, nUdhBytes);
                System.arraycopy(ud, 0, fullUd, nUdhBytes, nUdBytes);
                baos.write(fullUd);
            }
            baos.close();
        }
        catch (IOException ex) {
            throw new SmsException(ex);
        }
        return baos.toByteArray();
    }

    private static void writeDestinationAddress(OutputStream theOs, SmsAddress theDestination) throws IOException {
        String address = theDestination.getAddress();
        int ton = theDestination.getTypeOfNumber();
        int npi = theDestination.getNumberingPlanIdentification();
        if (address.charAt(0) == '+') {
            address = address.substring(1);
        }
        theOs.write(address.length());
        theOs.write(0x80 | ton << 4 | npi);
        SmsPduUtil.writeBcdNumber(theOs, address);
    }
}

