/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.transport.clickatell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.Properties;
import org.marre.sms.SmsAddress;
import org.marre.sms.SmsConcatMessage;
import org.marre.sms.SmsException;
import org.marre.sms.SmsMessage;
import org.marre.sms.SmsPdu;
import org.marre.sms.SmsPduUtil;
import org.marre.sms.SmsUdhElement;
import org.marre.sms.SmsUdhUtil;
import org.marre.sms.SmsUserData;
import org.marre.sms.transport.SmsTransport;
import org.marre.sms.transport.clickatell.ClickatellException;
import org.marre.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickatellTransport
implements SmsTransport {
    private static Logger log_ = LoggerFactory.getLogger((Class)(class$org$marre$sms$transport$clickatell$ClickatellTransport == null ? (class$org$marre$sms$transport$clickatell$ClickatellTransport = ClickatellTransport.class$("org.marre.sms.transport.clickatell.ClickatellTransport")) : class$org$marre$sms$transport$clickatell$ClickatellTransport));
    private String username_;
    private String password_;
    private String apiId_;
    private String sessionId_;
    private String protocol_;
    public static final int FEAT_TEXT = 1;
    public static final int FEAT_8BIT = 2;
    public static final int FEAT_UDH = 4;
    public static final int FEAT_UCS2 = 8;
    public static final int FEAT_ALPHA = 16;
    public static final int FEAT_NUMBER = 32;
    public static final int FEAT_REPLY = 64;
    public static final int FEAT_FLASH = 512;
    public static final int FEAT_DELIVACK = 8192;
    public static final int FEAT_CONCAT = 16384;
    public static final int FEAT_DEFAULT = 16399;
    static /* synthetic */ Class class$org$marre$sms$transport$clickatell$ClickatellTransport;

    private String[] sendRequest(String url, String requestString) throws ClickatellException, IOException {
        String response = null;
        MessageFormat responseFormat = new MessageFormat("{0}: {1}");
        LinkedList<String> idList = new LinkedList<String>();
        try {
            log_.info("sendRequest: posting : " + requestString + " to " + url);
            URL requestURL = new URL(url);
            URLConnection urlConn = requestURL.openConnection();
            urlConn.setDoInput(true);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            PrintWriter pw = new PrintWriter(urlConn.getOutputStream());
            pw.print(requestString);
            pw.flush();
            pw.close();
            InputStream is = urlConn.getInputStream();
            BufferedReader responseReader = new BufferedReader(new InputStreamReader(is));
            while ((response = responseReader.readLine()) != null) {
                Object[] objs = responseFormat.parse(response);
                if ("ERR".equalsIgnoreCase((String)objs[0])) {
                    MessageFormat errorFormat = new MessageFormat("{0}: {1}, {2}");
                    Object[] errObjs = errorFormat.parse(response);
                    String errorNo = (String)errObjs[1];
                    String description = (String)errObjs[2];
                    throw new ClickatellException("Clickatell error. Error " + errorNo + ", " + description, Integer.parseInt(errorNo));
                }
                log_.info("sendRequest: Got ID : " + (String)objs[1]);
                idList.add((String)objs[1]);
            }
            responseReader.close();
        }
        catch (ParseException ex) {
            throw new ClickatellException("Unexpected response from Clickatell. : " + response, -1);
        }
        return idList.toArray(new String[0]);
    }

    private String[] sendRequestWithRetry(String url, String requestString) throws SmsException, IOException {
        String[] msgIds;
        try {
            msgIds = this.sendRequest(url, requestString);
        }
        catch (ClickatellException ex) {
            switch (ex.getErrId()) {
                case 1: 
                case 3: {
                    this.connect();
                    try {
                        msgIds = this.sendRequest(url, requestString);
                        break;
                    }
                    catch (ClickatellException ex2) {
                        throw new SmsException(ex2.getMessage());
                    }
                }
                default: {
                    throw new SmsException(ex.getMessage());
                }
            }
        }
        return msgIds;
    }

    public void init(Properties props) throws SmsException {
        this.username_ = props.getProperty("smsj.clickatell.username");
        this.password_ = props.getProperty("smsj.clickatell.password");
        this.apiId_ = props.getProperty("smsj.clickatell.apiid");
        this.protocol_ = props.getProperty("smsj.clickatell.protocol", "http");
        if (this.username_ == null || this.password_ == null || this.apiId_ == null) {
            throw new SmsException("Incomplete login information for clickatell");
        }
        if (!this.protocol_.equals("http") && !this.protocol_.equals("https")) {
            throw new SmsException("Unsupported protocol : " + this.protocol_);
        }
    }

    public void connect() throws SmsException, IOException {
        String[] response = null;
        String url = this.protocol_ + "://api.clickatell.com/http/auth";
        String requestString = "api_id=" + this.apiId_;
        requestString = requestString + "&user=" + this.username_;
        requestString = requestString + "&password=" + this.password_;
        try {
            response = this.sendRequest(url, requestString);
        }
        catch (ClickatellException ex) {
            throw new SmsException(ex);
        }
        this.sessionId_ = response[0];
    }

    private String buildSendRequest(SmsUserData ud, byte[] udhData, SmsAddress dest, SmsAddress sender) throws SmsException {
        String requestString;
        int reqFeat;
        block14: {
            block13: {
                reqFeat = 0;
                requestString = "session_id=" + this.sessionId_;
                requestString = requestString + "&to=" + dest.getAddress();
                if (SmsUdhUtil.isConcat(ud, udhData)) {
                    requestString = requestString + "&concat=3";
                    reqFeat |= 0x4000;
                }
                if (sender != null) {
                    requestString = requestString + "&from=" + sender.getAddress();
                    reqFeat |= sender.getTypeOfNumber() == 5 ? 16 : 32;
                }
                if (ud.getDcs().getMessageClass() == 0) {
                    requestString = requestString + "&msg_type=SMS_FLASH";
                    reqFeat |= 0x200;
                }
                if (udhData != null && udhData.length != 0) break block13;
                switch (ud.getDcs().getAlphabet()) {
                    case 1: {
                        throw new SmsException("Clickatell API cannot send 8 bit encoded messages without UDH");
                    }
                    case 2: {
                        String udStr = StringUtil.bytesToHexString(ud.getData());
                        requestString = requestString + "&unicode=1";
                        requestString = requestString + "&text=" + udStr;
                        reqFeat |= 8;
                        break block14;
                    }
                    case 0: {
                        String msg = SmsPduUtil.readSeptets(ud.getData(), ud.getLength());
                        requestString = requestString + "&text=" + URLEncoder.encode(msg);
                        reqFeat |= 1;
                        break block14;
                    }
                    default: {
                        throw new SmsException("Unsupported data coding scheme");
                    }
                }
            }
            switch (ud.getDcs().getAlphabet()) {
                case 1: {
                    String udStr = StringUtil.bytesToHexString(ud.getData());
                    String udhStr = StringUtil.bytesToHexString(udhData);
                    requestString = requestString + "&udh=" + udhStr;
                    requestString = requestString + "&text=" + udStr;
                    reqFeat |= 6;
                    break;
                }
                case 2: {
                    String udStr = StringUtil.bytesToHexString(ud.getData());
                    String udhStr = StringUtil.bytesToHexString(udhData);
                    requestString = requestString + "&unicode=1";
                    requestString = requestString + "&udh=" + udhStr;
                    requestString = requestString + "&text=" + udStr;
                    reqFeat |= 0xC;
                    break;
                }
                case 0: {
                    throw new SmsException("Clickatell API cannot send 7 bit encoded messages with UDH");
                }
                default: {
                    throw new SmsException("Unsupported data coding scheme");
                }
            }
        }
        requestString = requestString + "&req_feat=" + reqFeat;
        return requestString;
    }

    private String[] sendConcatMessage(SmsConcatMessage theMsg, SmsAddress theDestination, SmsAddress theSender) throws SmsException, IOException {
        String url = this.protocol_ + "://api.clickatell.com/http/sendmsg";
        SmsUserData userData = theMsg.getUserData();
        SmsUdhElement[] udhElements = theMsg.getUdhElements();
        byte[] udhData = SmsUdhUtil.toByteArray(udhElements);
        String requestString = this.buildSendRequest(userData, udhData, theDestination, theSender);
        return this.sendRequestWithRetry(url, requestString);
    }

    private String send(SmsPdu thePdu, SmsAddress theDestination, SmsAddress theSender) throws SmsException, IOException {
        String url = this.protocol_ + "://api.clickatell.com/http/sendmsg";
        SmsUserData userData = thePdu.getUserData();
        byte[] udhData = thePdu.getUserDataHeaders();
        String requestString = this.buildSendRequest(userData, udhData, theDestination, theSender);
        return this.sendRequestWithRetry(url, requestString)[0];
    }

    public String send(SmsMessage msg, SmsAddress dest, SmsAddress sender) throws SmsException, IOException {
        if (dest.getTypeOfNumber() == 5) {
            throw new SmsException("Cannot sent SMS to an ALPHANUMERIC address");
        }
        if (this.sessionId_ == null) {
            throw new SmsException("Must connect before sending");
        }
        if (msg instanceof SmsConcatMessage) {
            String[] msgIds = this.sendConcatMessage((SmsConcatMessage)msg, dest, sender);
        } else {
            SmsPdu[] msgPdu = msg.getPdus();
            String[] msgIds = new String[msgPdu.length];
            for (int i = 0; i < msgPdu.length; ++i) {
                msgIds[i] = this.send(msgPdu[i], dest, sender);
            }
        }
        return null;
    }

    public void disconnect() throws SmsException, IOException {
    }

    public void ping() throws SmsException, IOException {
        String[] response = null;
        String url = this.protocol_ + "://api.clickatell.com/http/ping";
        String requestString = "session_id=" + this.sessionId_;
        try {
            response = this.sendRequest(url, requestString);
        }
        catch (ClickatellException ex) {
            throw new SmsException(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

