/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms.nokia;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;

public class OtaBitmap {
    private int myWidth;
    private int myHeight;
    private byte[] myOtaImgData;

    public OtaBitmap(byte[] otaBitmap) {
        if (otaBitmap != null) {
            byte infoField = otaBitmap[0];
            this.myWidth = otaBitmap[1];
            this.myHeight = otaBitmap[2];
            byte depth = otaBitmap[3];
            int length = otaBitmap.length - 4;
            this.myOtaImgData = new byte[length];
            System.arraycopy(otaBitmap, 4, this.myOtaImgData, 0, length);
        }
    }

    public OtaBitmap(BufferedImage theImg) {
        int bitOffset = 0;
        int data = 0;
        int nByte = 0;
        int nTotalBytes = 0;
        Raster raster = theImg.getData();
        this.myWidth = theImg.getWidth();
        this.myHeight = theImg.getHeight();
        nTotalBytes = this.myWidth * this.myHeight / 8;
        if (this.myWidth * this.myHeight % 8 > 0) {
            ++nTotalBytes;
        }
        this.myOtaImgData = new byte[nTotalBytes];
        for (int y = 0; y < this.myHeight; ++y) {
            for (int x = 0; x < this.myWidth; ++x) {
                int color = theImg.getRGB(x, y);
                if (color != 0) {
                    data |= 1 << 7 - bitOffset & 0xFF;
                }
                if (++bitOffset < 8) continue;
                this.myOtaImgData[nByte] = (byte)(data & 0xFF);
                bitOffset = 0;
                data = 0;
                ++nByte;
            }
        }
        if (bitOffset > 0) {
            this.myOtaImgData[nByte] = (byte)(data & 0xFF);
        }
    }

    public byte[] getImageData() {
        return this.myOtaImgData;
    }

    public byte[] getBytes() {
        byte[] otaBitmap = new byte[this.myOtaImgData.length + 4];
        otaBitmap[0] = 0;
        otaBitmap[1] = (byte)(this.myWidth & 0xFF);
        otaBitmap[2] = (byte)(this.myHeight & 0xFF);
        otaBitmap[3] = 1;
        System.arraycopy(this.myOtaImgData, 0, otaBitmap, 4, this.myOtaImgData.length);
        return otaBitmap;
    }

    public int getHeight() {
        return this.myHeight;
    }

    public int getWidth() {
        return this.myWidth;
    }

    public void setHeight(int i) {
        this.myHeight = i;
    }

    public void setWidth(int i) {
        this.myWidth = i;
    }
}

