/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.marre.sms.SmsDcs;
import org.marre.sms.SmsUdhElement;
import org.marre.sms.SmsUdhUtil;
import org.marre.sms.SmsUserData;

public class SmsPdu {
    protected SmsUdhElement[] myUdhElements;
    protected SmsUserData myUd;

    public SmsPdu() {
    }

    public SmsPdu(SmsUdhElement[] theUdhIeis, byte[] theUd, int theUdLength, SmsDcs theDataCodingScheme) {
        this.setUserDataHeaders(theUdhIeis);
        this.setUserData(theUd, theUdLength, theDataCodingScheme);
    }

    public SmsPdu(SmsUdhElement[] theUdhIeis, SmsUserData theUd) {
        this.setUserDataHeaders(theUdhIeis);
        this.setUserData(theUd);
    }

    public void setUserDataHeaders(SmsUdhElement[] theUdhElements) {
        if (theUdhElements != null) {
            this.myUdhElements = new SmsUdhElement[theUdhElements.length];
            System.arraycopy(theUdhElements, 0, this.myUdhElements, 0, theUdhElements.length);
        } else {
            this.myUdhElements = null;
        }
    }

    public byte[] getUserDataHeaders() {
        if (this.myUdhElements == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
        baos.write((byte)SmsUdhUtil.getTotalSize(this.myUdhElements));
        try {
            for (int i = 0; i < this.myUdhElements.length; ++i) {
                this.myUdhElements[i].writeTo(baos);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to write to ByteArrayOutputStream");
        }
        return baos.toByteArray();
    }

    public void setUserData(byte[] theUd, int theUdLength, SmsDcs theDataCodingScheme) {
        this.myUd = new SmsUserData(theUd, theUdLength, theDataCodingScheme);
    }

    public void setUserData(SmsUserData theUd) {
        this.myUd = theUd;
    }

    public SmsUserData getUserData() {
        return this.myUd;
    }

    public SmsDcs getDcs() {
        return this.myUd.getDcs();
    }
}

