/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import java.util.Iterator;
import java.util.LinkedList;
import org.marre.sms.SmsDcs;
import org.marre.sms.SmsTextMessage;
import org.marre.sms.SmsUdhElement;

public class SmsMsgWaitingMessage
extends SmsTextMessage {
    public static final int TYPE_VOICE = 0;
    public static final int TYPE_FAX = 1;
    public static final int TYPE_EMAIL = 2;
    public static final int TYPE_VIDEO = 3;
    private static final int OPT_PROFILE_MASK = 3;
    public static final int OPT_PROFILE_ID_1 = 0;
    public static final int OPT_PROFILE_ID_2 = 1;
    public static final int OPT_PROFILE_ID_3 = 2;
    public static final int OPT_PROFILE_ID_4 = 3;
    public static final int OPT_STORE_MSG = 4;
    protected LinkedList messages_ = new LinkedList();

    public SmsMsgWaitingMessage() {
        this("", 1);
    }

    public SmsMsgWaitingMessage(String text) {
        this(text, 0);
    }

    public SmsMsgWaitingMessage(String text, int alphabet) {
        super(text, SmsDcs.getGeneralDataCodingDcs(alphabet, (byte)4));
    }

    public void addMsgWaiting(int type, int count) {
        this.addMsgWaiting(type, count, 0);
    }

    public void addMsgWaiting(int type, int count, int options) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type.");
            }
        }
        if (count > 255) {
            count = 255;
        }
        this.messages_.add(new MsgWaiting(type, count, options));
    }

    protected SmsUdhElement getMessageWaitingUdh(MsgWaiting msgWaiting) {
        byte[] udh = new byte[2];
        switch (msgWaiting.type) {
            case 0: {
                udh[0] = 0;
                break;
            }
            case 1: {
                udh[0] = 1;
                break;
            }
            case 2: {
                udh[0] = 2;
                break;
            }
            case 3: {
                udh[0] = 7;
                break;
            }
            default: {
                throw new RuntimeException("Invalid message type.");
            }
        }
        switch (msgWaiting.options & 3) {
            case 0: {
                udh[0] = (byte)(udh[0] | 0);
                break;
            }
            case 1: {
                udh[0] = (byte)(udh[0] | 0x20);
                break;
            }
            case 2: {
                udh[0] = (byte)(udh[0] | 0x40);
                break;
            }
            case 3: {
                udh[0] = (byte)(udh[0] | 0x60);
                break;
            }
            default: {
                throw new RuntimeException("Invalid option.");
            }
        }
        if ((msgWaiting.options & 4) != 0) {
            udh[0] = (byte)(udh[0] | 0xFFFFFF80);
        }
        udh[1] = (byte)(msgWaiting.count & 0xFF);
        return new SmsUdhElement(1, udh);
    }

    public SmsUdhElement[] getUdhElements() {
        SmsUdhElement[] udhElements = null;
        int msgCount = this.messages_.size();
        if (msgCount > 0) {
            udhElements = new SmsUdhElement[this.messages_.size()];
            int i = 0;
            Iterator j = this.messages_.iterator();
            while (j.hasNext()) {
                MsgWaiting msgWaiting = (MsgWaiting)j.next();
                udhElements[i] = this.getMessageWaitingUdh(msgWaiting);
                ++i;
            }
        }
        return udhElements;
    }

    private class MsgWaiting {
        int type;
        int count;
        int options;

        private MsgWaiting(int type, int count, int options) {
            this.type = type;
            this.count = count;
            this.options = options;
        }
    }
}

