/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

public class SmsDcs {
    public static final int ALPHABET_GSM = 0;
    public static final int ALPHABET_8BIT = 1;
    public static final int ALPHABET_UCS2 = 2;
    public static final int ALPHABET_RESERVED = 3;
    public static final int ALPHABET_UNKNOWN = 4;
    public static final byte MSG_CLASS_0 = 0;
    public static final byte MSG_CLASS_1 = 1;
    public static final byte MSG_CLASS_2 = 2;
    public static final byte MSG_CLASS_3 = 3;
    public static final byte MSG_CLASS_UNKNOWN = 4;
    public static final int GROUP_GENERAL_DATA_CODING = 0;
    public static final int GROUP_MESSAGE_WAITING_DISCARD = 1;
    public static final int GROUP_MESSAGE_WAITING_STORE_GSM = 2;
    public static final int GROUP_MESSAGE_WAITING_STORE_UCS2 = 3;
    public static final int GROUP_DATA_CODING_MESSAGE = 4;
    public static final int GROUP_UNKNOWN = 5;
    public static final byte DCS_MSG_WAITING_VOICEMAIL = 0;
    public static final byte DCS_MSG_WAITING_FAX = 1;
    public static final byte DCS_MSG_WAITING_EMAIL = 2;
    public static final byte DCS_MSG_WAITING_OTHER = 3;
    protected byte dcs_;

    public SmsDcs(byte dcs) {
        this.dcs_ = dcs;
    }

    public byte getValue() {
        return this.dcs_;
    }

    public static SmsDcs getGeneralDataCodingDcs(int alphabet, byte messageClass) {
        byte dcs = 0;
        switch (alphabet) {
            case 0: {
                dcs = (byte)(dcs | 0);
                break;
            }
            case 1: {
                dcs = (byte)(dcs | 4);
                break;
            }
            case 2: {
                dcs = (byte)(dcs | 8);
                break;
            }
            case 3: {
                dcs = (byte)(dcs | 0xC);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid alphabet");
            }
        }
        switch (messageClass) {
            case 0: {
                dcs = (byte)(dcs | 0x10);
                break;
            }
            case 1: {
                dcs = (byte)(dcs | 0x11);
                break;
            }
            case 2: {
                dcs = (byte)(dcs | 0x12);
                break;
            }
            case 3: {
                dcs = (byte)(dcs | 0x13);
                break;
            }
            case 4: {
                dcs = (byte)(dcs | 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid message class");
            }
        }
        return new SmsDcs(dcs);
    }

    public int getAlphabet() {
        switch (this.getGroup()) {
            case 0: {
                if (this.dcs_ == 0) {
                    return 0;
                }
                switch (this.dcs_ & 0xC) {
                    case 0: {
                        return 0;
                    }
                    case 4: {
                        return 1;
                    }
                    case 8: {
                        return 2;
                    }
                    case 12: {
                        return 3;
                    }
                }
                return 4;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 2;
            }
            case 4: {
                switch (this.dcs_ & 4) {
                    case 0: {
                        return 0;
                    }
                    case 4: {
                        return 1;
                    }
                }
                return 4;
            }
        }
        return 4;
    }

    public int getGroup() {
        if ((this.dcs_ & 0xC0) == 0) {
            return 0;
        }
        switch (this.dcs_ & 0xF0) {
            case 192: {
                return 1;
            }
            case 208: {
                return 2;
            }
            case 224: {
                return 3;
            }
            case 240: {
                return 4;
            }
        }
        return 5;
    }

    public int getMessageClass() {
        switch (this.getGroup()) {
            case 0: {
                if (this.dcs_ == 0) {
                    return 4;
                }
                switch (this.dcs_ & 0x13) {
                    case 16: {
                        return 0;
                    }
                    case 17: {
                        return 1;
                    }
                    case 18: {
                        return 2;
                    }
                    case 19: {
                        return 3;
                    }
                }
                return 4;
            }
            case 4: {
                switch (this.dcs_ & 3) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                }
                return 4;
            }
        }
        return 4;
    }
}

