/*
 * Decompiled with CFR 0.152.
 */
package org.marre.sms;

import org.marre.sms.SmsException;

public class SmsAddress {
    private static final String ALLOWED_DIGITS = "+0123456789*#ab";
    private int myTon = 1;
    private int myNpi = 1;
    private String myAddress;

    public SmsAddress(String theAddress) throws SmsException {
        int npi = 1;
        int ton = 1;
        for (int i = 0; i < theAddress.length(); ++i) {
            char ch = theAddress.charAt(i);
            if (ALLOWED_DIGITS.indexOf(ch) != -1) continue;
            ton = 5;
            npi = 0;
            break;
        }
        this.init(theAddress, ton, npi);
    }

    public SmsAddress(String theAddress, int theTon, int theNpi) throws SmsException {
        this.init(theAddress, theTon, theNpi);
    }

    private void init(String theAddress, int theTon, int theNpi) throws SmsException {
        if (theAddress == null) {
            throw new SmsException("Empty address.");
        }
        this.myTon = theTon;
        this.myAddress = theAddress.trim();
        int addressLength = this.myAddress.length();
        if (addressLength == 0) {
            throw new SmsException("Empty address.");
        }
        if (theTon == 5) {
            this.myNpi = 0;
            if (theAddress.length() > 11) {
                throw new SmsException("Alphanumeric address can be at most 11 chars.");
            }
        } else {
            this.myNpi = theNpi;
            if (this.myAddress.charAt(0) == '+') {
                this.myAddress = this.myAddress.substring(1);
                --addressLength;
            }
            if (addressLength > 20) {
                throw new SmsException("Too long address, Max allowed is 20 digits (excluding any inital '+').");
            }
            for (int i = 0; i < theAddress.length(); ++i) {
                char ch = theAddress.charAt(i);
                if (ALLOWED_DIGITS.indexOf(ch) != -1) continue;
                throw new SmsException("Invalid digit in address. '" + ch + "'.");
            }
        }
    }

    public String getAddress() {
        return this.myAddress;
    }

    public int getTypeOfNumber() {
        return this.myTon;
    }

    public int getNumberingPlanIdentification() {
        return this.myNpi;
    }
}

