/*
 * Decompiled with CFR 0.152.
 */
package org.marre.mime.encoder;

import java.io.IOException;
import java.io.OutputStream;
import org.marre.mime.MimeBodyPart;
import org.marre.mime.MimeContentType;
import org.marre.mime.MimeHeader;
import org.marre.mime.MimeHeaderParam;
import org.marre.mime.MimeMultipart;
import org.marre.mime.encoder.MimeEncoder;
import org.marre.util.StringUtil;

public class TextMimeEncoder
implements MimeEncoder {
    private static final int DEFAULT_BOUNDARY_STRING_LENGTH = 35;

    public void writeContentType(OutputStream theOs, MimeBodyPart theMsg) throws IOException {
        MimeContentType ct = theMsg.getContentType();
        if (theMsg instanceof MimeMultipart) {
            String boundary = StringUtil.randString(35);
            ct.setParam("boundary", boundary);
        }
        this.writeHeader(theOs, ct);
    }

    public void writeHeaders(OutputStream theOs, MimeBodyPart theMsg) throws IOException {
        for (int i = 0; i < theMsg.getHeaderCount(); ++i) {
            MimeHeader header = theMsg.getHeader(i);
            this.writeHeader(theOs, header);
        }
        theOs.write("\r\n".getBytes());
    }

    public void writeBody(OutputStream theOs, MimeBodyPart theMsg) throws IOException {
        if (theMsg instanceof MimeMultipart) {
            String ct = theMsg.getContentType().getValue();
            if (!ct.startsWith("application/vnd.wap.multipart.")) {
                this.writeMultipart(theOs, (MimeMultipart)theMsg);
            }
        } else {
            theOs.write(theMsg.getBody());
            theOs.write("\r\n".getBytes());
        }
    }

    protected void writeHeader(OutputStream theOs, MimeHeader header) throws IOException {
        StringBuffer strBuff = new StringBuffer();
        String name = header.getName();
        String value = header.getValue();
        strBuff.append(name + ": " + value);
        for (int i = 0; i < header.getParamCount(); ++i) {
            MimeHeaderParam headerParam = header.getParam(i);
            strBuff.append("; " + headerParam.getName() + "=" + headerParam.getValue());
        }
        strBuff.append("\r\n");
        theOs.write(strBuff.toString().getBytes());
    }

    private void writeMultipart(OutputStream theOs, MimeMultipart theMultipart) throws IOException {
        MimeContentType ct = theMultipart.getContentType();
        MimeHeaderParam boundaryParam = ct.getParam("boundary");
        String boundary = "--" + boundaryParam.getValue();
        for (int i = 0; i < theMultipart.getBodyPartCount(); ++i) {
            MimeBodyPart part = theMultipart.getBodyPart(i);
            theOs.write(boundary.getBytes());
            theOs.write("\r\n".getBytes());
            this.writeContentType(theOs, part);
            this.writeHeaders(theOs, part);
            this.writeBody(theOs, part);
        }
        theOs.write(boundary.getBytes());
        theOs.write("--\r\n".getBytes());
    }
}

