/*
 * Decompiled with CFR 0.152.
 */
package org.marre.mime;

import java.io.UnsupportedEncodingException;
import org.marre.mime.MimeBodyPart;
import org.marre.mime.MimeContentType;

public final class MimeUtil {
    private MimeUtil() {
    }

    public static MimeBodyPart createTextBodyPart(String str) {
        return MimeUtil.createTextBodyPart(str, "text/plain");
    }

    public static MimeBodyPart createTextBodyPart(String str, String contentType) {
        MimeBodyPart textBodyPart = new MimeBodyPart();
        MimeContentType ct = new MimeContentType(contentType);
        ct.setParam("charset", "utf-8");
        byte[] data = null;
        try {
            data = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        textBodyPart.setContent(data, ct);
        return textBodyPart;
    }

    public static MimeBodyPart createBinaryBodyPart(byte[] content, String contentType) {
        MimeBodyPart binBodyPart = new MimeBodyPart();
        binBodyPart.setContent(content, contentType);
        return binBodyPart;
    }
}

