/*
 * Decompiled with CFR 0.152.
 */
package org.marre.mime;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.marre.mime.MimeHeaderParam;

public class MimeHeader {
    protected String myHeaderName;
    protected String myHeaderValue;
    protected List myParams;

    protected MimeHeader() {
    }

    public MimeHeader(String theName, String theValue) {
        this.myHeaderName = theName;
        this.myHeaderValue = theValue;
        this.myParams = new LinkedList();
    }

    public void setValue(String theValue) {
        this.myHeaderValue = theValue;
    }

    public String getName() {
        return this.myHeaderName;
    }

    public String getValue() {
        return this.myHeaderValue;
    }

    public void setParam(String theName, String theValue) {
        this.removeParam(theName);
        this.myParams.add(new MimeHeaderParam(theName, theValue));
    }

    public MimeHeaderParam getParam(String theName) {
        Iterator iter = this.myParams.iterator();
        while (iter.hasNext()) {
            MimeHeaderParam param = (MimeHeaderParam)iter.next();
            if (!param.getName().equalsIgnoreCase(theName)) continue;
            return param;
        }
        return null;
    }

    public void removeParam(String theName) {
        MimeHeaderParam param = this.getParam(theName);
        if (param != null) {
            this.myParams.remove(param);
        }
    }

    public List getAllParams() {
        return this.myParams;
    }

    public int getParamCount() {
        return this.myParams.size();
    }

    public MimeHeaderParam getParam(int theIndex) {
        return (MimeHeaderParam)this.myParams.get(theIndex);
    }

    public String toString() {
        String s = this.myHeaderName + "=" + this.myHeaderValue;
        Iterator i = this.myParams.iterator();
        while (i.hasNext()) {
            MimeHeaderParam mhp = (MimeHeaderParam)i.next();
            s = mhp.getName() + "=" + mhp.getValue();
        }
        return s;
    }
}

