/*
 * Decompiled with CFR 0.152.
 */
package org.marre;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.marre.sms.SmsAddress;
import org.marre.sms.SmsException;
import org.marre.sms.SmsMessage;
import org.marre.sms.SmsMsgWaitingMessage;
import org.marre.sms.SmsTextMessage;
import org.marre.sms.transport.SmsTransport;
import org.marre.sms.transport.SmsTransportManager;
import org.marre.wap.nokia.NokiaOtaBrowserSettings;
import org.marre.wap.push.SmsMmsNotificationMessage;
import org.marre.wap.push.SmsWapPushMessage;
import org.marre.wap.push.WapSIPush;
import org.marre.wap.push.WapSLPush;
import org.marre.wap.wbxml.WbxmlDocument;

public class SmsSender {
    protected SmsTransport transport_;

    public SmsSender(String transport, Properties props) throws SmsException {
        this.transport_ = SmsTransportManager.getTransport(transport, props);
    }

    public static SmsSender getClickatellSender(String username, String password, String apiid) throws SmsException {
        Properties props = new Properties();
        props.setProperty("smsj.clickatell.username", username);
        props.setProperty("smsj.clickatell.password", password);
        props.setProperty("smsj.clickatell.apiid", apiid);
        props.setProperty("smsj.clickatell.protocol", "https");
        return new SmsSender("org.marre.sms.transport.clickatell.ClickatellTransport", props);
    }

    public static SmsSender getClickatellSender(String propsFilename) throws SmsException, IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(propsFilename));
        return new SmsSender("org.marre.sms.transport.clickatell.ClickatellTransport", props);
    }

    public static SmsSender getGsmSender(String portName) throws SmsException {
        Properties props = new Properties();
        props.setProperty("sms.gsm.serialport", portName);
        return new SmsSender("org.marre.sms.transport.gsm.GsmTransport", props);
    }

    public static SmsSender getUcpSender(String address, int port) throws SmsException {
        Properties props = new Properties();
        props.setProperty("smsj.ucp.ip.host", address);
        props.setProperty("smsj.ucp.ip.port", Integer.toString(port));
        return new SmsSender("org.marre.sms.transport.ucp.UcpTransport", props);
    }

    public static SmsSender getUcpSender(String address, int port, String ucp60Uid, String ucp60Pwd) throws SmsException {
        Properties props = new Properties();
        props.setProperty("smsj.ucp.ip.host", address);
        props.setProperty("smsj.ucp.ip.port", Integer.toString(port));
        props.setProperty("smsj.ucp.ucp60.uid", ucp60Uid);
        props.setProperty("smsj.ucp.ucp60.password", ucp60Pwd);
        return new SmsSender("org.marre.sms.transport.ucp.UcpTransport", props);
    }

    public static SmsSender getUcpSender(String propsFilename) throws SmsException, IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(propsFilename));
        return new SmsSender("org.marre.sms.transport.ucp.UcpTransport", props);
    }

    public static SmsSender getPsWinCommXmlSender(String username, String password) throws SmsException {
        Properties props = new Properties();
        props.setProperty("smsj.pswincom.username", username);
        props.setProperty("smsj.pswincom.password", password);
        return new SmsSender("org.marre.sms.transport.pswincom.PsWinXmlTransport", props);
    }

    public static SmsSender getPsWinCommXmlSender(String propsFilename) throws SmsException, IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(propsFilename));
        return new SmsSender("org.marre.sms.transport.pswincom.PsWinXmlTransport", props);
    }

    public String sendTextSms(String text, String dest, String sender) throws SmsException, IOException {
        SmsTextMessage textMessage = new SmsTextMessage(text, 0, 4);
        return this.sendSms(textMessage, dest, sender);
    }

    public String sendTextSms(String text, String dest) throws SmsException, IOException {
        SmsTextMessage textMessage = new SmsTextMessage(text, 0, 4);
        return this.sendSms(textMessage, dest, null);
    }

    public String sendUnicodeTextSms(String text, String dest, String sender) throws SmsException, IOException {
        SmsTextMessage textMessage = new SmsTextMessage(text, 2, 4);
        return this.sendSms(textMessage, dest, sender);
    }

    public String sendUnicodeTextSms(String text, String dest) throws SmsException, IOException {
        SmsTextMessage textMessage = new SmsTextMessage(text, 2, 4);
        return this.sendSms(textMessage, dest, null);
    }

    public String sendNokiaBookmark(String title, String url, String dest) throws SmsException, IOException {
        NokiaOtaBrowserSettings browserSettings = new NokiaOtaBrowserSettings();
        browserSettings.addBookmark(title, url);
        SmsWapPushMessage wapPushMessage = new SmsWapPushMessage((WbxmlDocument)browserSettings, "application/x-wap-prov.browser-bookmarks");
        wapPushMessage.setPorts(49154, 49999);
        return this.sendSms(wapPushMessage, dest, null);
    }

    public String sendWapSiPushMsg(String url, String text, String dest) throws SmsException, IOException {
        WapSIPush siPush = new WapSIPush(url, text);
        SmsWapPushMessage wapPushMessage = new SmsWapPushMessage(siPush);
        return this.sendSms(wapPushMessage, dest, null);
    }

    public String sendWapSlPushMsg(String url, String dest) throws SmsException, IOException {
        WapSLPush slPush = new WapSLPush(url);
        SmsWapPushMessage wapPushMessage = new SmsWapPushMessage(slPush);
        return this.sendSms(wapPushMessage, dest, null);
    }

    public String sendMmsNotification(String contentLocation, long size, String subject, String dest) throws SmsException, IOException {
        SmsMmsNotificationMessage mmsNotification = new SmsMmsNotificationMessage(contentLocation, size);
        mmsNotification.setSubject(subject);
        return this.sendSms(mmsNotification, dest, null);
    }

    public String sendMsgWaitingVoice(int count, String dest) throws SmsException, IOException {
        return this.sendMsgWaiting(0, count, dest);
    }

    public String sendMsgWaitingFax(int count, String dest) throws SmsException, IOException {
        return this.sendMsgWaiting(1, count, dest);
    }

    public String sendMsgWaitingEmail(int count, String dest) throws SmsException, IOException {
        return this.sendMsgWaiting(2, count, dest);
    }

    private String sendMsgWaiting(int type, int count, String dest) throws SmsException, IOException {
        SmsMsgWaitingMessage msgWaiting = new SmsMsgWaitingMessage();
        msgWaiting.addMsgWaiting(type, count);
        return this.sendSms(msgWaiting, dest, null);
    }

    public String sendSms(SmsMessage msg, String dest, String sender) throws SmsException, IOException {
        SmsAddress destAddress = new SmsAddress(dest);
        SmsAddress senderAddress = null;
        if (sender != null) {
            senderAddress = new SmsAddress(sender);
        }
        return this.transport_.send(msg, destAddress, senderAddress);
    }

    public void connect() throws SmsException, IOException {
        this.transport_.connect();
    }

    public void disconnect() throws SmsException, IOException {
        if (this.transport_ != null) {
            this.transport_.disconnect();
            this.transport_ = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }
}

