/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import org.jivesoftware.smack.compression.Java7ZlibInputOutputStream;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.initializer.SmackInitializer;
import org.jivesoftware.smack.parsing.ExceptionThrowingCallback;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.FileUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public final class SmackConfiguration {
    private static final String SMACK_VERSION;
    private static final String DEFAULT_CONFIG_FILE = "classpath:org.jivesoftware.smack/smack-config.xml";
    private static final Logger LOGGER;
    private static int defaultPacketReplyTimeout;
    private static int packetCollectorSize;
    private static List<String> defaultMechs;
    private static Set<String> disabledSmackClasses;
    private static final List<XMPPInputOutputStream> compressionHandlers;
    public static boolean DEBUG_ENABLED;
    private static ParsingExceptionCallback defaultCallback;
    private static HostnameVerifier defaultHostnameVerififer;

    public static String getVersion() {
        return SMACK_VERSION;
    }

    public static int getDefaultPacketReplyTimeout() {
        if (defaultPacketReplyTimeout <= 0) {
            defaultPacketReplyTimeout = 5000;
        }
        return defaultPacketReplyTimeout;
    }

    public static void setDefaultPacketReplyTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException();
        }
        defaultPacketReplyTimeout = timeout;
    }

    public static int getPacketCollectorSize() {
        return packetCollectorSize;
    }

    public static void setPacketCollectorSize(int collectorSize) {
        packetCollectorSize = collectorSize;
    }

    public static void addSaslMech(String mech) {
        if (!defaultMechs.contains(mech)) {
            defaultMechs.add(mech);
        }
    }

    public static void addSaslMechs(Collection<String> mechs) {
        for (String mech : mechs) {
            SmackConfiguration.addSaslMech(mech);
        }
    }

    public static void removeSaslMech(String mech) {
        defaultMechs.remove(mech);
    }

    public static void removeSaslMechs(Collection<String> mechs) {
        defaultMechs.removeAll(mechs);
    }

    public static List<String> getSaslMechs() {
        return Collections.unmodifiableList(defaultMechs);
    }

    public static void setDefaultParsingExceptionCallback(ParsingExceptionCallback callback) {
        defaultCallback = callback;
    }

    public static ParsingExceptionCallback getDefaultParsingExceptionCallback() {
        return defaultCallback;
    }

    public static void addCompressionHandler(XMPPInputOutputStream xmppInputOutputStream) {
        compressionHandlers.add(xmppInputOutputStream);
    }

    public static List<XMPPInputOutputStream> getCompresionHandlers() {
        ArrayList<XMPPInputOutputStream> res = new ArrayList<XMPPInputOutputStream>(compressionHandlers.size());
        for (XMPPInputOutputStream ios : compressionHandlers) {
            if (!ios.isSupported()) continue;
            res.add(ios);
        }
        return res;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier verifier) {
        defaultHostnameVerififer = verifier;
    }

    static HostnameVerifier getDefaultHostnameVerifier() {
        return defaultHostnameVerififer;
    }

    public static void processConfigFile(InputStream cfgFileStream, Collection<Exception> exceptions) throws Exception {
        SmackConfiguration.processConfigFile(cfgFileStream, exceptions, SmackConfiguration.class.getClassLoader());
    }

    public static void processConfigFile(InputStream cfgFileStream, Collection<Exception> exceptions, ClassLoader classLoader) throws Exception {
        XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        parser.setInput(cfgFileStream, "UTF-8");
        int eventType = parser.getEventType();
        do {
            if (eventType != 2) continue;
            if (parser.getName().equals("startupClasses")) {
                SmackConfiguration.parseClassesToLoad(parser, false, exceptions, classLoader);
                continue;
            }
            if (!parser.getName().equals("optionalStartupClasses")) continue;
            SmackConfiguration.parseClassesToLoad(parser, true, exceptions, classLoader);
        } while ((eventType = parser.next()) != 1);
        try {
            cfgFileStream.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error while closing config file input stream", e);
        }
    }

    private static void parseClassesToLoad(XmlPullParser parser, boolean optional, Collection<Exception> exceptions, ClassLoader classLoader) throws XmlPullParserException, IOException, Exception {
        String name;
        int eventType;
        String startName = parser.getName();
        do {
            eventType = parser.next();
            name = parser.getName();
            if (eventType != 2 || !"className".equals(name)) continue;
            String classToLoad = parser.nextText();
            if (disabledSmackClasses.contains(classToLoad)) {
                LOGGER.info("Not loading disabled Smack class " + classToLoad);
                continue;
            }
            try {
                SmackConfiguration.loadSmackClass(classToLoad, optional, classLoader);
            }
            catch (Exception e) {
                if (exceptions != null) {
                    exceptions.add(e);
                    continue;
                }
                throw e;
            }
        } while (eventType != 3 || !startName.equals(name));
    }

    private static void loadSmackClass(String className, boolean optional, ClassLoader classLoader) throws Exception {
        Class<?> initClass;
        try {
            initClass = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            Level logLevel = optional ? Level.FINE : Level.WARNING;
            LOGGER.log(logLevel, "A startup class '" + className + "' could not be loaded.");
            if (!optional) {
                throw cnfe;
            }
            return;
        }
        if (SmackInitializer.class.isAssignableFrom(initClass)) {
            SmackInitializer initializer = (SmackInitializer)initClass.newInstance();
            List exceptions = initializer.initialize();
            if (exceptions.size() == 0) {
                LOGGER.log(Level.FINE, "Loaded SmackInitializer " + className);
            } else {
                for (Exception e : exceptions) {
                    LOGGER.log(Level.SEVERE, "Exception in loadSmackClass", e);
                }
            }
        } else {
            LOGGER.log(Level.FINE, "Loaded " + className);
        }
    }

    static {
        InputStream configFileStream;
        String smackVersion;
        LOGGER = Logger.getLogger(SmackConfiguration.class.getName());
        defaultPacketReplyTimeout = 5000;
        packetCollectorSize = 5000;
        defaultMechs = new ArrayList<String>();
        disabledSmackClasses = new HashSet<String>();
        compressionHandlers = new ArrayList<XMPPInputOutputStream>(2);
        DEBUG_ENABLED = false;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(FileUtils.getStreamForUrl((String)"classpath:org.jivesoftware.smack/version", null)));
            smackVersion = reader.readLine();
            try {
                reader.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "IOException closing stream", e);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not determine Smack version", e);
            smackVersion = "unkown";
        }
        SMACK_VERSION = smackVersion;
        String disabledClasses = System.getProperty("smack.disabledClasses");
        if (disabledClasses != null) {
            String[] splitDisabledClasses;
            for (String s : splitDisabledClasses = disabledClasses.split(",")) {
                disabledSmackClasses.add(s);
            }
        }
        try {
            FileUtils.addLines((String)"classpath:org.jivesoftware.smack/disabledClasses", disabledSmackClasses);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        try {
            Class<?> c = Class.forName("org.jivesoftware.smack.CustomSmackConfiguration");
            Field f = c.getField("DISABLED_SMACK_CLASSES");
            String[] sa = (String[])f.get(null);
            if (sa != null) {
                for (String s : sa) {
                    disabledSmackClasses.add(s);
                }
            }
        }
        catch (ClassNotFoundException e1) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        try {
            configFileStream = FileUtils.getStreamForUrl((String)DEFAULT_CONFIG_FILE, null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        try {
            SmackConfiguration.processConfigFile(configFileStream, null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        compressionHandlers.add(new Java7ZlibInputOutputStream());
        try {
            DEBUG_ENABLED = Boolean.getBoolean("smack.debugEnabled");
        }
        catch (Exception exception) {
            // empty catch block
        }
        DNSUtil.init();
        defaultCallback = new ExceptionThrowingCallback();
    }
}

