<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8" session="false" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<fmt:setLocale value="${param.locale}"  />
<fmt:setBundle basename="pl.smartapps.restserver.servlet.Messages" />
<jsp:include page="Header.jsp" flush="false" />
<title><fmt:message key="changePassword.pageTitle" /></title>

<jsp:include page="WrapperHeader.jsp" flush="false" />

	<div id="form-wrapper">
		<h1 class="title"><fmt:message key="changePassword.pageTitle" /></h1>
		<form action="changePassword?code=<%=request.getParameter("code")%>" method="post">
			<input type="password" name="password" value="" class="password_input" placeholder="<fmt:message key='changePassword.password' />">
			<hr>
			<input type="password" name="confirmPassword" value="" class="password_input" placeholder="<fmt:message key='changePassword.confirmPassword' />" >
			<input type="hidden" name="code" value="<%=request.getParameter("code")%>">
			<br />
			<input type="submit" value="<fmt:message key='changePassword.submit' />" class="submit">
		</form>

<%
	String status = (String) request.getAttribute("status");
	String message;
	if (status != null) {
		if (status.equals("FAILED_PASSWORDINVALID")) {
			message = "Password invalid, it should be at least 8 characters long and include at least one capital letter and one digit";
		} else {
			message = "Unexpected error has occurred";
		}
%>
		<div class="error"><span><%=message%></span></div>
		<script type="text/javascript">
			$(document).ready(function() {
				$('.errorMsg').slideDown(200, function(){
      				$(document).on('click', function(){ $('.errorMsg').slideUp(100); }); 
    			}); 
    		});
		</script>
<%
	}
%>
		
	</div>

<jsp:include page="WrapperFooter.jsp" flush="false" />