DROP TABLE camera IF EXISTS;

DROP TABLE gatewayclient IF EXISTS;
CREATE TABLE gatewayclient (
	gateway_client_id int GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
	user_id int NOT NULL,
	mac varchar(17) NOT NULL,
	name varchar(100) NOT NULL,
	serial_number varchar(45) NOT NULL,
	activation_date timestamp NOT NULL,
	modification_date timestamp NULL,
	deleted boolean not null
);

DROP TABLE devicedesc IF EXISTS;
CREATE TABLE devicedesc (
  devicedesc_id int GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
  class varchar(45) NOT NULL,
  make varchar(100) NOT NULL,
  model varchar(100) NOT NULL,
  driverclass varchar(100) NOT NULL
);

DROP TABLE role IF EXISTS;
CREATE TABLE role (
  id int GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
  name varchar(45) NOT NULL,
  UNIQUE (name)
);

DROP TABLE _user IF EXISTS;
CREATE TABLE _user (
  id int GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
  username varchar(100) NOT NULL,
  email varchar(100) NOT NULL,
  password varchar(100) NOT NULL,
  password_salt varchar(255) NOT NULL,
  deleted boolean not null
);

DROP TABLE landevice IF EXISTS;
CREATE TABLE landevice (
  landevice_id int GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
  gateway_client_id int NOT NULL,
  name varchar(100) NOT NULL,
  description varchar(200) NULL,
  location varchar(200) NULL,
  added_date timestamp NOT NULL,
  mac varchar(17) NOT NULL,
  ip_address varchar(15) NOT NULL,
  port varchar(5) NOT NULL,
  user varchar(100) NOT NULL,
  pass varchar(100) NOT NULL,
  devicedesc_id int NOT NULL,
  version varchar(45) NULL,
  user_id int NOT NULL,
  deleted boolean not null
);

DROP TABLE landeviceparam IF EXISTS;
CREATE TABLE landeviceparam (
  landeviceparam_id int GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL,
  landevice_id int NOT NULL,
  name varchar(45) NOT NULL,
  value varchar(50) NOT NULL,
  desired_value varchar(50) NULL
);


