/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.util.webdis;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.util.webdis.ExecutionResult;
import pl.smartapps.restserver.util.webdis.Job;
import pl.smartapps.restserver.util.webdis.WebdisConnector;

@Service
@Scope(value="prototype")
public class WebdisExecutor {
    private static Logger log = Logger.getLogger(WebdisExecutor.class);
    private WebdisConnector webdisConnector;
    private List<Job> jobs = new ArrayList();

    @Autowired
    @Required
    public void setWebdisConnector(WebdisConnector webdisConnector) {
        this.webdisConnector = webdisConnector;
    }

    public void set(String key, String value) {
        this.jobs.add(new Job(Job.Operation.SET, key, value));
    }

    public void del(String key) {
        this.jobs.add(new Job(Job.Operation.DEL, key));
    }

    public ExecutionResult execute(GatewayClientEntity client, boolean stopOnFailure) {
        for (Job job : this.jobs) {
            if (job.getOperation() == Job.Operation.SET) {
                if (this.executeSet(client, job)) continue;
                break;
            }
            if (job.getOperation() == Job.Operation.DEL) {
                if (this.executeDel(client, job) || !stopOnFailure) continue;
                break;
            }
            log.warn((Object)("Unsupported opperation: " + job.getOperation()));
        }
        return new ExecutionResult(this.jobs);
    }

    private boolean executeSet(GatewayClientEntity client, Job job) {
        if (this.webdisConnector.set(client, job.getKey(), job.getValue())) {
            job.setStatus(Boolean.valueOf(true));
            return true;
        }
        job.setStatus(Boolean.valueOf(false));
        return false;
    }

    private boolean executeDel(GatewayClientEntity client, Job job) {
        block3: {
            try {
                if (!this.webdisConnector.del(client, job.getKey())) break block3;
                job.setStatus(Boolean.valueOf(true));
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        job.setStatus(Boolean.valueOf(false));
        return false;
    }
}

