/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.util.webdis;

import com.amazonaws.services.cloudfront_2012_03_15.model.InvalidArgumentException;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.vestiacom.gdserver.rest.response.HTTPClientServiceResult;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import pl.smartapps.containerserver.ContainerserverServiceFactory;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.util.Utils;
import pl.smartapps.restserver.util.webdis.WebdisConnector;

@Service
public class WebdisConnector {
    private static Logger log = Logger.getLogger(WebdisConnector.class);
    private ContainerserverServiceFactory serviceFactory;

    @Autowired
    @Required
    public void setServiceFactory(ContainerserverServiceFactory serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public boolean set(GatewayClientEntity client, String key, String value) {
        if (client == null) {
            throw new InvalidArgumentException("null client");
        }
        if (Utils.isBlank((String)key)) {
            throw new InvalidArgumentException("Undefined or null key");
        }
        if (value == null) {
            throw new InvalidArgumentException("Null value");
        }
        String url = this.getUrl(Command.SET, new String[]{key, value});
        Map response = (Map)this.send(client.getSerialNumber(), url, (TypeToken)new /* Unavailable Anonymous Inner Class!! */);
        if (!this.validateReponse(response, Command.SET)) {
            log.warn((Object)("Invalid response for client=" + client.getGatewayClientId() + ", key=" + key + ", value=" + value + ", " + response));
            return false;
        }
        List status = (List)response.get(Command.SET.toString());
        if (status.get(0).equals(true)) {
            return true;
        }
        log.warn((Object)("Failed to execute SET command with key=" + key + ", value=" + value + ": " + status.get(1)));
        return false;
    }

    private String getUrl(Command command, String ... args) {
        return this.getUrl("127.0.0.1", Integer.valueOf(7379), command, args);
    }

    private String getUrl(String address, Integer port, Command command, String ... args) {
        StringBuilder url = new StringBuilder();
        if (!address.startsWith("http://")) {
            url.append("http://");
        }
        url.append(address).append(":").append(port).append("/");
        url.append(command).append("/");
        url.append(args[0]);
        if (command == Command.SET) {
            url.append("/").append(args[1]);
        }
        return url.toString();
    }

    private <T> T send(String deviceId, String url, TypeToken<T> typeToken) {
        HTTPClientServiceResult response = this.send(deviceId, url);
        if (response.getResult() == HTTPClientServiceResult.Result.OK) {
            Gson gson = new Gson();
            return (T)gson.fromJson(response.getBodyAsText(), typeToken.getType());
        }
        return null;
    }

    private HTTPClientServiceResult send(String deviceId, String request) {
        log.trace((Object)("start send(deviceId=" + deviceId + ", request=" + request + ")"));
        HTTPClientServiceResult response = null;
        try {
            URL url = new URL(request);
            response = this.serviceFactory.getHttpClientService().get(deviceId, url);
            log.trace((Object)("Response text:" + (response == null ? "null" : response.toString())));
            if (response == null) {
                log.warn((Object)("Received null response for request=" + request + ", deviceId=" + deviceId + "."));
                return new HTTPClientServiceResult(HTTPClientServiceResult.Result.ERROR);
            }
            return response;
        }
        catch (MalformedURLException ex) {
            log.warn((Object)("Failed to send '" + request + "' for deviceId=" + deviceId + ": " + ex.getMessage()));
            return new HTTPClientServiceResult(HTTPClientServiceResult.Result.ERROR);
        }
    }

    private boolean validateReponse(Map<String, ?> response, Command command) {
        return response != null && !response.isEmpty() && response.containsKey(command.toString());
    }

    public String get(GatewayClientEntity client, String key) {
        if (client == null) {
            throw new InvalidArgumentException("Null client");
        }
        if (Utils.isBlank((String)key)) {
            throw new InvalidArgumentException("Undefined or null key");
        }
        String url = this.getUrl(Command.GET, new String[]{key});
        Map response = (Map)this.send(client.getSerialNumber(), url, (TypeToken)new /* Unavailable Anonymous Inner Class!! */);
        if (!this.validateReponse(response, Command.GET)) {
            log.warn((Object)("Invalid response for client=" + client.getGatewayClientId() + ", key=" + key + ": " + response));
            throw new RuntimeException("Invalid response for command=GET and key=" + key);
        }
        return (String)response.get(Command.GET.toString());
    }

    public boolean del(GatewayClientEntity client, String key) {
        if (client == null) {
            throw new InvalidArgumentException("Null client");
        }
        if (Utils.isBlank((String)key)) {
            throw new InvalidArgumentException("Undefined or null key");
        }
        String url = this.getUrl(Command.DEL, new String[]{key});
        Map response = (Map)this.send(client.getSerialNumber(), url, (TypeToken)new /* Unavailable Anonymous Inner Class!! */);
        if (!this.validateReponse(response, Command.DEL)) {
            log.warn((Object)("Invalid response for client=" + client.getGatewayClientId() + ", key=" + key + ": " + response));
            throw new RuntimeException("Invalid response for command=DEL and key=" + key);
        }
        return ((Integer)response.get(Command.DEL.toString())).equals(1);
    }
}

