/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.util;

import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    private static final Logger log = Logger.getLogger(Utils.class);
    private static final String DIGITS_PATTERN = "[0-9]+";

    public static Date parseDate(String text, String pattern, Locale locale, TimeZone timeZone) {
        log.debug((Object)("start parseDate(text=" + text + ", pattern=" + pattern + ", locale=" + locale + ")"));
        if (locale == null) {
            locale = Locale.getDefault();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, locale);
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        try {
            return dateFormat.parse(text);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date parseDate(String text, String pattern) {
        log.debug((Object)("start parseDate(text=" + text + " , pattern=" + pattern + ")"));
        return Utils.parseDate((String)text, (String)pattern, null, null);
    }

    public static String formatDate(Date date, String pattern) {
        log.debug((Object)("start formatDate(date=" + date + ", pattern=" + pattern + ")"));
        if (date == null) {
            log.warn((Object)"Date converted to text can not be null");
            return null;
        }
        if (pattern == null) {
            log.warn((Object)"Pattern can not be null to convert date to text.");
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    public static String formatDate(Date date, String pattern, Locale locale) {
        log.debug((Object)("start formatDate(date=" + date + ", pattern=" + pattern + ", locale=" + locale + ")"));
        if (date == null) {
            log.warn((Object)"Date converted to text can not be null");
            return null;
        }
        if (pattern == null) {
            log.warn((Object)"Pattern can not be null to convert date to text.");
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, locale);
        return dateFormat.format(date);
    }

    public static Date buildDate(Integer seconds, Integer microseconds) {
        long date = seconds.longValue() * 1000L + microseconds.longValue() / 1000L;
        return new Date(date);
    }

    public static Date adjustTime(Date date, int hour, int minute, int second, int millisecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar.getTime();
    }

    public static Date truncateTime(Date date) {
        return Utils.adjustTime((Date)date, (int)0, (int)0, (int)0, (int)0);
    }

    public static Date adjustDate(Date date, int field, int amount, boolean addMode) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        if (addMode) {
            cal.add(field, amount);
        } else {
            cal.set(field, amount);
        }
        return cal.getTime();
    }

    public static String formatMacAddress(String mac) {
        if (mac == null) {
            return null;
        }
        if ((mac = mac.replaceAll("[:-]", "")).length() != 12) {
            return null;
        }
        StringBuilder formattedMac = new StringBuilder();
        formattedMac.append(mac.substring(0, 2)).append(":");
        formattedMac.append(mac.substring(2, 4)).append(":");
        formattedMac.append(mac.substring(4, 6)).append(":");
        formattedMac.append(mac.substring(6, 8)).append(":");
        formattedMac.append(mac.substring(8, 10)).append(":");
        formattedMac.append(mac.substring(10, 12));
        return formattedMac.toString().toUpperCase();
    }

    public static boolean isAtMinimalVersion(String gatewayClientVersion, String minimalVersion) {
        boolean uses = false;
        if (gatewayClientVersion == null || minimalVersion == null) {
            return uses;
        }
        String[] lanDeviceValues = gatewayClientVersion.split("\\.");
        String[] minimalValues = minimalVersion.split("\\.");
        if (lanDeviceValues.length != 2 || minimalValues.length != 2) {
            return uses;
        }
        int lanDeviceMajor = Integer.parseInt(lanDeviceValues[0]);
        int lanDeviceMinor = Integer.parseInt(lanDeviceValues[1]);
        int minimalMajor = Integer.parseInt(minimalValues[0]);
        int minimalMinor = Integer.parseInt(minimalValues[1]);
        if (lanDeviceMajor > minimalMajor) {
            uses = true;
        } else if (lanDeviceMajor < minimalMajor) {
            uses = false;
        } else if (lanDeviceMinor >= minimalMinor) {
            uses = true;
        }
        return uses;
    }

    public static Integer clamp(Integer value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static boolean isBlank(String text) {
        return text == null || text.trim().isEmpty();
    }

    public static Integer getSize(Collection<?> collection) {
        return collection == null ? null : Integer.valueOf(collection.size());
    }

    public static Integer getSize(Map<?, ?> map) {
        return map == null ? null : Integer.valueOf(map.size());
    }

    public static <T> StringEntity createEntity(T source) throws UnsupportedEncodingException {
        Gson gson = new Gson();
        String json = gson.toJson(source);
        return new StringEntity(json);
    }

    public static boolean isDigits(String text) {
        return text != null && text.matches("[0-9]+");
    }
}

