/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.util;

import org.apache.commons.lang3.StringUtils;

public class MacAddressRange {
    private long startMac;
    private long endMac;

    public MacAddressRange(String startMac, String endMac) {
        this.startMac = this.toLong(startMac);
        this.endMac = this.toLong(endMac);
    }

    private long toLong(String mac) {
        if (!this.isMacAddress(mac)) {
            throw new IllegalArgumentException("invalid mac address: " + mac);
        }
        return Long.parseLong(mac.replace(":", ""), 16);
    }

    private boolean isMacAddress(String text) {
        return !StringUtils.isBlank((CharSequence)text) && text.matches("^([0-9A-F]{2}[:]){5}([0-9A-F]{2})$");
    }

    public boolean contains(String mac) {
        long numberedMac = this.toLong(mac);
        return numberedMac >= this.startMac && numberedMac <= this.endMac;
    }
}

