/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ResponseHeaderOverrides;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import pl.smartapps.restserver.util.AwsS3ControllerApp;

/*
 * Exception performing whole class analysis ignored.
 */
public class AwsS3ControllerApp {
    private TransferManager tm;
    private String bucketName;
    private AmazonS3 s3client;
    private Properties properties;
    private static Logger log = Logger.getLogger(AwsS3ControllerApp.class);

    public void init() throws IOException {
        this.properties = new Properties();
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("awsController.properties");
        this.properties.load(in);
        in.close();
        1 credentials = new /* Unavailable Anonymous Inner Class!! */;
        this.s3client = new AmazonS3Client((AWSCredentials)credentials);
        String serverAddress = this.properties.getProperty("aws.serverAddress");
        String serverPort = this.properties.getProperty("aws.serverPort");
        if (serverAddress != null) {
            this.s3client.setEndpoint(String.valueOf(serverAddress) + (serverPort != null ? ":" + serverPort : ""));
        }
        this.tm = new TransferManager(this.s3client);
        this.bucketName = this.properties.getProperty("aws.bucketName");
        if (this.bucketName == null) {
            throw new IllegalArgumentException(this.bucketName);
        }
    }

    public boolean uploadFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            String keyName = filePath.substring(filePath.lastIndexOf("/") > -1 ? filePath.lastIndexOf("/") + 1 : 0);
            log.debug((Object)("Uploading file: " + keyName));
            Upload upload = this.tm.upload(this.bucketName, keyName, file);
            try {
                upload.waitForCompletion();
            }
            catch (AmazonClientException amazonClientException) {
                log.warn((Object)("Unable to upload file '" + filePath + "', upload was aborted."));
                amazonClientException.printStackTrace();
                return false;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    public URL generateDownloadLink(String key, String filename) {
        Date expiryDate = new Date();
        expiryDate.setTime(expiryDate.getTime() + 86400000L);
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(this.bucketName, key);
        ResponseHeaderOverrides responseHeaders = new ResponseHeaderOverrides().withContentDisposition("attachment; filename=" + filename);
        request.setResponseHeaders(responseHeaders);
        request.setExpiration(expiryDate);
        URL link = this.s3client.generatePresignedUrl(request);
        return link;
    }

    public boolean deleteFile(String fileName) {
        try {
            DeleteObjectRequest request = new DeleteObjectRequest(this.bucketName, fileName);
            this.s3client.deleteObject(request);
        }
        catch (AmazonServiceException ase) {
            return false;
        }
        catch (AmazonClientException ace) {
            return false;
        }
        return true;
    }

    public boolean fileExists(String fileName) {
        try {
            this.s3client.getObjectMetadata(this.bucketName, fileName);
        }
        catch (AmazonServiceException ase) {
            return false;
        }
        catch (AmazonClientException ace) {
            return false;
        }
        return true;
    }

    public void stop() {
        this.tm.shutdownNow();
    }

    public static void main(String[] args) throws IOException {
        String line;
        AwsS3ControllerApp.configureLogging();
        AwsS3ControllerApp awsApp = new AwsS3ControllerApp();
        awsApp.init();
        int read = 0;
        int uploaded = 0;
        BufferedReader br = new BufferedReader(new FileReader(args[0]));
        while ((line = br.readLine()) != null) {
            if (line.isEmpty()) continue;
            ++read;
            if (!awsApp.uploadFile(line)) continue;
            ++uploaded;
        }
        br.close();
        awsApp.stop();
        log.debug((Object)("Read " + read + " filenames, uploaded " + uploaded + " files."));
    }

    private static void configureLogging() throws IOException {
        Logger root = Logger.getRootLogger();
        root.setLevel(Level.DEBUG);
        PatternLayout layout = new PatternLayout("%d [%t] %x %-5p %c - %m%n");
        root.addAppender((Appender)new FileAppender((Layout)layout, "awsController.log"));
        Logger.getLogger((String)"org.apache.http").setLevel(Level.ERROR);
        Logger.getLogger((String)"com.amazonaws").setLevel(Level.WARN);
        Logger.getLogger((String)"pl.smartapps.restserver.util.AwsS3ControllerApp").setLevel(Level.DEBUG);
    }

    static /* synthetic */ Properties access$0(AwsS3ControllerApp awsS3ControllerApp) {
        return awsS3ControllerApp.properties;
    }
}

