/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.test.rest;

import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.easymock.Capture;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.LanDeviceParam;
import pl.smartapps.restserver.db.main.DebuglogEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.test.rest.ExaminedUrl;
import pl.smartapps.restserver.test.rest.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    private static Logger log = Logger.getLogger(Utils.class);

    public static Date constructDate(int year, int month, int day) {
        GregorianCalendar cal = Utils.constructGregorianCalendar((int)year, (int)month, (int)day, (int)0, (int)0, (int)0);
        return cal.getTime();
    }

    public static Date constructDate(int year, int month, int day, int hour, int minute, int second) {
        GregorianCalendar cal = Utils.constructGregorianCalendar((int)year, (int)month, (int)day, (int)hour, (int)minute, (int)second);
        return cal.getTime();
    }

    public static GregorianCalendar constructGregorianCalendar(int year, int month, int day, int hour, int minute, int second) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, 0);
        return cal;
    }

    public static Date adjustDate(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static <T> List<T> wrap(T ... args) {
        ArrayList<T> container = new ArrayList<T>();
        T[] TArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            T arg = TArray[n2];
            container.add(arg);
            ++n2;
        }
        return container;
    }

    public static boolean verifyUrl(String expectedUrl, String capturedUrl) {
        ExaminedUrl expected = new ExaminedUrl(expectedUrl);
        ExaminedUrl captured = new ExaminedUrl(capturedUrl);
        if (!expected.equals((Object)captured)) {
            System.out.println("urls are not equal");
            System.out.println("captured url: " + captured);
            System.out.println("expected url: " + expected);
            return false;
        }
        return true;
    }

    public static boolean verifyUrl(String expectedUrl, Capture<URL> capturedUrl) {
        return Utils.verifyUrl((String)expectedUrl, (String)((URL)capturedUrl.getValue()).toString());
    }

    public static boolean verifyTextUrl(String expectedUrl, Capture<String> capturedUrl) {
        return Utils.verifyUrl((String)expectedUrl, (String)((String)capturedUrl.getValue()));
    }

    public static void addDeviceParam(LanDeviceEntity device, String name, String value, String remoteValue) {
        if (device.getLanDeviceParams() == null) {
            device.setLanDeviceParams(new ArrayList());
        }
        LanDeviceParamEntity param = new LanDeviceParamEntity();
        param.setName(name);
        param.setValue(value);
        param.setRemoteValue(remoteValue);
        device.getLanDeviceParams().add(param);
    }

    public static void addDeviceParam(LanDeviceEntity device, Integer id, String name, String value, String remoteValue) {
        if (device.getLanDeviceParams() == null) {
            device.setLanDeviceParams(new ArrayList());
        }
        LanDeviceParamEntity param = new LanDeviceParamEntity();
        param.setName(name);
        param.setValue(value);
        param.setRemoteValue(remoteValue);
        device.getLanDeviceParams().add(param);
    }

    public static void addDeviceParam(LanDevice device, String name, String value, String remoteValue) {
        if (device.getLanDeviceParams() == null) {
            device.setLanDeviceParams(new ArrayList());
        }
        LanDeviceParam param = new LanDeviceParam();
        param.setName(name);
        param.setValue(value);
        param.setRemoteValue(remoteValue);
        device.getLanDeviceParams().add(param);
    }

    public static boolean verifyDebullogEnity(Capture<DebuglogEntity> captured, DebuglogEntity expected) {
        DebuglogEntity actual = (DebuglogEntity)captured.getValue();
        if (actual == expected) {
            return true;
        }
        if (expected == null) {
            return false;
        }
        if (actual.getClass() != expected.getClass()) {
            return false;
        }
        if (actual.getDebuglogId() == null ? expected.getDebuglogId() != null : !actual.getDebuglogId().equals(expected.getDebuglogId())) {
            return false;
        }
        if (actual.getFile() == null ? expected.getFile() != null : !actual.getFile().equals(expected.getFile())) {
            return false;
        }
        if (actual.getJsessionId() == null ? expected.getJsessionId() != null : !actual.getJsessionId().equals(expected.getJsessionId())) {
            return false;
        }
        if (actual.getLine() != expected.getLine()) {
            return false;
        }
        if (actual.getLogLevel() == null ? expected.getLogLevel() != null : !actual.getLogLevel().equals(expected.getLogLevel())) {
            return false;
        }
        if (actual.getLoggerName() == null ? expected.getLoggerName() != null : !actual.getLoggerName().equals(expected.getLoggerName())) {
            return false;
        }
        if (actual.getMac() == null ? expected.getMac() != null : !actual.getMac().equals(expected.getMac())) {
            return false;
        }
        if (actual.getMessage() == null ? expected.getMessage() != null : !actual.getMessage().equals(expected.getMessage())) {
            return false;
        }
        if (actual.getNdc() == null ? expected.getNdc() != null : !actual.getNdc().equals(expected.getNdc())) {
            return false;
        }
        if (actual.getThread() == null ? expected.getThread() != null : !actual.getThread().equals(expected.getThread())) {
            return false;
        }
        if (actual.getUsername() == null ? expected.getUsername() != null : !actual.getUsername().equals(expected.getUsername())) {
            return false;
        }
        return Utils.verifyTimestamp((Date)actual.getTimestamp(), (Date)expected.getTimestamp());
    }

    private static boolean verifyTimestamp(Date actual, Date expected) {
        Calendar act = Calendar.getInstance();
        act.setTime(actual);
        Calendar exp = Calendar.getInstance();
        exp.setTime(expected);
        return act.get(1) == exp.get(1) && act.get(2) == exp.get(2) && act.get(5) == exp.get(5) && act.get(11) == exp.get(11) && act.get(12) == exp.get(12) && act.get(13) == exp.get(13);
    }

    public static boolean verifyDevice(LanDeviceEntity expectedDevice, LanDeviceEntity device) {
        log.debug((Object)("expected: " + expectedDevice));
        log.debug((Object)("current:  " + device));
        if (!expectedDevice.equals((Object)device)) {
            log.debug((Object)"Device are not equals");
            return false;
        }
        1 paramComparator = new /* Unavailable Anonymous Inner Class!! */;
        List expectedParams = expectedDevice.getLanDeviceParams();
        List params = device.getLanDeviceParams();
        Collections.sort(expectedParams, paramComparator);
        System.out.println("expectedParams: " + expectedParams);
        Collections.sort(params, paramComparator);
        System.out.println("params:         " + params);
        return expectedParams.equals(params);
    }
}

