/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.test.rest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hsqldb.Server;

public class DbSupport {
    private static Logger log = Logger.getLogger(DbSupport.class);
    private Server hsqlServer = null;
    private Connection connection = null;
    private File createSqlScript;
    private File inserSqlScript;
    private String dbName;
    private Map<String, String> dbProperties;

    public DbSupport(File createSqlScript, File inserSqlScript, String dbName) {
        this.createSqlScript = createSqlScript;
        this.inserSqlScript = inserSqlScript;
        this.dbName = dbName;
        this.dbProperties = this.prepareDbProperties(dbName);
    }

    private Map<String, String> prepareDbProperties(String dbName) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("javax.persistence.jdbc.url", "jdbc:hsqldb:hsql:mem:" + dbName);
        result.put("javax.persistence.jdbc.password", "");
        result.put("javax.persistence.jdbc.driver", "org.hsqldb.jdbcDriver");
        result.put("javax.persistence.jdbc.user", "sa");
        return result;
    }

    public Map<String, String> getDbProperties() {
        return this.dbProperties;
    }

    public void creteDatabase() throws ClassNotFoundException, SQLException {
        String[] insertRow;
        this.hsqlServer = new Server();
        this.hsqlServer.setLogWriter(null);
        this.hsqlServer.setSilent(true);
        this.hsqlServer.setDatabaseName(0, this.dbName);
        this.hsqlServer.setDatabasePath(0, "mem:" + this.dbName);
        this.hsqlServer.start();
        Class.forName("org.hsqldb.jdbcDriver");
        this.connection = DriverManager.getConnection("jdbc:hsqldb:hsql:mem:" + this.dbName, "sa", "");
        String create = this.readFromFile(this.createSqlScript);
        this.connection.prepareStatement(create).execute();
        String insert = this.readFromFile(this.inserSqlScript);
        String[] stringArray = insertRow = insert.split("\n");
        int n = insertRow.length;
        int n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            if (row.trim().length() != 0) {
                this.connection.prepareStatement(row).execute();
            }
            ++n2;
        }
    }

    private String readFromFile(File file) {
        StringBuilder result = new StringBuilder();
        try {
            if (file.exists() && file.isFile()) {
                BufferedReader bufRead = new BufferedReader(new FileReader(file));
                String readLine = null;
                while ((readLine = bufRead.readLine()) != null) {
                    result.append(readLine);
                    result.append(System.getProperty("line.separator"));
                }
                bufRead.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            log.error((Object)("File " + file.getAbsolutePath() + "not found "), (Throwable)fnfe);
        }
        catch (IOException ioe) {
            log.error((Object)"IO exception during reading file", (Throwable)ioe);
        }
        return result.toString();
    }

    public void cleanup() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        this.hsqlServer.stop();
    }
}

