/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.sso;

import com.allen_sauer.gwt.log.client.Log;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import pl.smartapps.restserver.db.dao.SSOServiceDAO;
import pl.smartapps.restserver.db.main.SSOServiceEntity;
import pl.smartapps.restserver.sso.SsoProvider;
import pl.smartapps.restserver.sso.SsoProviderException;

@Component
public class SsoProviderFactory
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private SSOServiceDAO ssoServiceDAO;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Autowired
    @Required
    public void setSsoServiceDAO(SSOServiceDAO ssoServiceDAO) {
        this.ssoServiceDAO = ssoServiceDAO;
    }

    public SsoProvider getProvider(String name) throws SsoProviderException {
        if (StringUtils.isBlank((CharSequence)name)) {
            Log.warn((String)"Got blank sso provider");
            throw new SsoProviderException(SsoProviderException.ErrorCode.PROVIDER_UNSUPPORTED);
        }
        SSOServiceEntity ssoService = this.ssoServiceDAO.findSSOServiceByName(name);
        if (ssoService == null) {
            throw new SsoProviderException(SsoProviderException.ErrorCode.PROVIDER_UNSUPPORTED);
        }
        SsoProvider provider = (SsoProvider)this.applicationContext.getBean(ssoService.getBeanclass());
        provider.setSsoService(ssoService);
        return provider;
    }
}

