/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.sso;

import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import pl.smartapps.restserver.db.dao.SSOParameterDAO;
import pl.smartapps.restserver.db.main.SSOParameterEntity;
import pl.smartapps.restserver.db.main.SSOServiceEntity;
import pl.smartapps.restserver.sso.SsoProviderException;
import pl.smartapps.restserver.sso.SsoUser;

public abstract class SsoProvider {
    protected SSOServiceEntity ssoService;
    private SSOParameterDAO ssoParameterDAO;

    public void setSsoService(SSOServiceEntity ssoService) {
        this.ssoService = ssoService;
    }

    public SSOServiceEntity getSsoService() {
        return this.ssoService;
    }

    @Autowired
    @Required
    public void setSsoParameterDAO(SSOParameterDAO ssoParameterDAO) {
        this.ssoParameterDAO = ssoParameterDAO;
    }

    public abstract String fetchAccessToken(String var1) throws SsoProviderException;

    public abstract SsoUser fetchUser(HttpServletRequest var1) throws SsoProviderException;

    public abstract SsoUser fetchUser(String var1) throws SsoProviderException;

    public abstract SsoUser fetchUser(String var1, String var2) throws SsoProviderException;

    public String getString(String code, String defaultValue) {
        SSOParameterEntity param = this.ssoParameterDAO.findSSOParameter(this.ssoService.getName(), code);
        return param == null ? defaultValue : param.getValue();
    }

    public Boolean getBoolean(String code, Boolean defaultValue) {
        SSOParameterEntity param = this.ssoParameterDAO.findSSOParameter(this.ssoService.getName(), code);
        return param == null ? defaultValue : Boolean.valueOf(param.getValue());
    }

    public Integer getInteger(String code, Integer defaultValue) {
        SSOParameterEntity param = this.ssoParameterDAO.findSSOParameter(this.ssoService.getName(), code);
        return param == null ? defaultValue : Integer.valueOf(param.getValue());
    }
}

