/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.sso;

import com.restfb.DefaultFacebookClient;
import com.restfb.FacebookClient;
import com.restfb.Parameter;
import com.restfb.Version;
import com.restfb.exception.FacebookException;
import com.restfb.types.User;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import pl.smartapps.restserver.sso.SsoProvider;
import pl.smartapps.restserver.sso.SsoProviderException;
import pl.smartapps.restserver.sso.SsoUser;

@Component
public class FacebookSsoProvider
extends SsoProvider {
    private static final Logger log = Logger.getLogger(FacebookSsoProvider.class);
    private String serverUrl;

    @Value(value="${lanDevice.serverUrl}")
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String fetchAccessToken(String code) throws SsoProviderException {
        if (StringUtils.isBlank((CharSequence)code)) {
            log.warn((Object)"Failed to obtain access token with facebook sso provider: code is blank");
            throw new SsoProviderException(SsoProviderException.ErrorCode.NOT_AUTHENTICATED);
        }
        try {
            DefaultFacebookClient client = new DefaultFacebookClient(Version.VERSION_2_3);
            FacebookClient.AccessToken accessToken = client.obtainUserAccessToken(this.getAppId(), this.getAppSecret(), this.getRedirectUrl(), code);
            return accessToken.getAccessToken();
        }
        catch (FacebookException ex) {
            log.warn((Object)("Failed to obtain facebook access token: " + ex.getMessage()));
            throw new SsoProviderException(SsoProviderException.ErrorCode.NOT_AUTHENTICATED);
        }
    }

    private String getAppId() throws SsoProviderException {
        String appId = this.getString("appId", null);
        if (StringUtils.isBlank((CharSequence)appId)) {
            log.warn((Object)("Invalid appId parameter for facebook sso provider: " + appId));
            throw new SsoProviderException(SsoProviderException.ErrorCode.INVALID_CONFIGURATION);
        }
        return appId;
    }

    private String getAppSecret() throws SsoProviderException {
        String appSecret = this.getString("appSecret", null);
        if (StringUtils.isBlank((CharSequence)appSecret)) {
            log.warn((Object)("Invalid appSecret parameter for facebook sso provider: " + appSecret));
            throw new SsoProviderException(SsoProviderException.ErrorCode.INVALID_CONFIGURATION);
        }
        return appSecret;
    }

    private String getRedirectUrl() {
        StringBuilder redirectUrl = new StringBuilder();
        if (this.serverUrl.endsWith("/")) {
            redirectUrl.append(this.serverUrl);
        } else {
            redirectUrl.append(this.serverUrl).append("/");
        }
        redirectUrl.append("sso");
        return redirectUrl.toString();
    }

    public SsoUser fetchUser(HttpServletRequest request) throws SsoProviderException {
        return this.fetchUser(request.getParameter("accessToken"));
    }

    public SsoUser fetchUser(String accessToken) throws SsoProviderException {
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn((Object)"Failed to authenticated user with facebook sso provider: accessToken is blank");
            throw new SsoProviderException(SsoProviderException.ErrorCode.NOT_AUTHENTICATED);
        }
        DefaultFacebookClient client = new DefaultFacebookClient(accessToken, Version.VERSION_2_3);
        User user = (User)client.fetchObject("me", User.class, new Parameter[0]);
        log.trace((Object)("Got user with facebook sso provider: " + user));
        if (user == null || StringUtils.isBlank((CharSequence)user.getEmail())) {
            log.warn((Object)"Failed to authenticated user with facebook sso provider: got user is null or email is blank");
            throw new SsoProviderException(SsoProviderException.ErrorCode.NOT_AUTHENTICATED);
        }
        SsoUser ssoUser = new SsoUser();
        ssoUser.setId(user.getId());
        ssoUser.setEmail(user.getEmail());
        ssoUser.setFirstName(user.getFirstName());
        ssoUser.setLastName(user.getLastName());
        return ssoUser;
    }

    public SsoUser fetchUser(String email, String password) throws SsoProviderException {
        return null;
    }
}

