/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.sso;

import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;
import pl.smartapps.restserver.sso.EpicentroSsoProvider;
import pl.smartapps.restserver.sso.SsoProvider;
import pl.smartapps.restserver.sso.SsoProviderException;
import pl.smartapps.restserver.sso.SsoUser;

@Component
public class EpicentroSsoProvider
extends SsoProvider {
    private static final Logger log = Logger.getLogger(EpicentroSsoProvider.class);
    private static final String EMAIL_PLACEHOLDER = "%EMAIL%";
    private static final String PASSWORD_PLACEHOLDER = "%PASSWORD%";
    private static final String TOKEN_PLACEHOLDER = "%TOKEN%";

    public String fetchAccessToken(String code) throws SsoProviderException {
        return null;
    }

    public SsoUser fetchUser(HttpServletRequest request) throws SsoProviderException {
        return this.fetchUser(request.getParameter("check_token"));
    }

    public SsoUser fetchUser(String token) throws SsoProviderException {
        if (StringUtils.isBlank((CharSequence)token)) {
            log.warn((Object)("There is a blank token while fetching user for " + this.ssoService.getName() + " sso provider"));
            throw new SsoProviderException(SsoProviderException.ErrorCode.NOT_AUTHENTICATED);
        }
        return this.getUser(this.getUrl(token));
    }

    private String getUrl(String token) throws SsoProviderException {
        String url = this.getString("installation_check_url", null);
        if (StringUtils.isBlank((CharSequence)url)) {
            log.warn((Object)("Invalid installation_check_url parameter for epicentro sso provider: " + url));
            throw new SsoProviderException(SsoProviderException.ErrorCode.INVALID_CONFIGURATION);
        }
        return url.replace(TOKEN_PLACEHOLDER, token);
    }

    public SsoUser fetchUser(String email, String password) throws SsoProviderException {
        if (StringUtils.isBlank((CharSequence)email)) {
            log.warn((Object)("There is a blank email while fetching user for " + this.ssoService.getName() + " sso provider"));
            throw new SsoProviderException(SsoProviderException.ErrorCode.NOT_AUTHENTICATED);
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            log.warn((Object)("There is a blank password while fetching user for " + this.ssoService.getName() + " sso provider"));
            throw new SsoProviderException(SsoProviderException.ErrorCode.NOT_AUTHENTICATED);
        }
        return this.getUser(this.getUrl(email, password));
    }

    private String getUrl(String email, String password) throws SsoProviderException {
        String url = this.getString("authenticate_url", null);
        if (StringUtils.isBlank((CharSequence)url)) {
            log.warn((Object)("Invalid authenticate_url parameter for epicentro sso provider: " + url));
            throw new SsoProviderException(SsoProviderException.ErrorCode.INVALID_CONFIGURATION);
        }
        url = url.replace(EMAIL_PLACEHOLDER, email);
        url = url.replace(PASSWORD_PLACEHOLDER, password);
        return url;
    }

    private SsoUser getUser(String url) throws SsoProviderException {
        UserInfo userInfo = this.get(url);
        if (userInfo == null) {
            throw new SsoProviderException(SsoProviderException.ErrorCode.ERROR);
        }
        if (StringUtils.isBlank((CharSequence)userInfo.authToken) || !StringUtils.isBlank((CharSequence)userInfo.error)) {
            throw new SsoProviderException(SsoProviderException.ErrorCode.NOT_AUTHENTICATED);
        }
        SsoUser ssoUser = new SsoUser();
        ssoUser.setId(userInfo.id);
        ssoUser.setEmail(userInfo.email);
        ssoUser.setFirstName(userInfo.firstName);
        ssoUser.setLastName(userInfo.lastName);
        ssoUser.setCpe(userInfo.cpe);
        return ssoUser;
    }

    private UserInfo get(String url) throws SsoProviderException {
        try {
            HttpGet httpGet = new HttpGet(url);
            X509HostnameVerifier hostnameVerifier = SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */}, new SecureRandom());
            SSLSocketFactory sf = new SSLSocketFactory(sslContext);
            sf.setHostnameVerifier(hostnameVerifier);
            Scheme httpsScheme = new Scheme("https", 443, (SchemeSocketFactory)sf);
            Scheme httpScheme = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(httpsScheme);
            schemeRegistry.register(httpScheme);
            SingleClientConnManager cm = new SingleClientConnManager(schemeRegistry);
            DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)cm);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            log.debug((Object)("EpicentroUserInfoRequest:execute() response from epicentro service = " + (response != null ? response.toString() : null)));
            UserInfo userInfo = new UserInfo(response.getEntity().getContent());
            return userInfo;
        }
        catch (Exception ex) {
            log.warn((Object)("Failed to execute GET request to " + this.ssoService.getName() + " sso provider: " + ex.getMessage()));
            if (log.isDebugEnabled()) {
                ex.printStackTrace();
            }
            throw new SsoProviderException(SsoProviderException.ErrorCode.ERROR);
        }
    }
}

