/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.servlet;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.HttpRequestHandler;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.service.EventService;
import pl.smartapps.restserver.servlet.VivotekMotionDetectionEventServlet;
import pl.smartapps.restserver.util.Utils;

public class VivotekMotionDetectionEventServlet
implements HttpRequestHandler {
    private static Logger log = Logger.getLogger(VivotekMotionDetectionEventServlet.class);
    private EventService eventService;
    private LanDeviceDAO lanDeviceDAO;

    @Autowired
    @Required
    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    @Autowired
    @Required
    public void setLanDeviceDAO(LanDeviceDAO lanDeviceDAO) {
        this.lanDeviceDAO = lanDeviceDAO;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String macAddress = Utils.formatMacAddress((String)request.getParameter("id"));
        LanDeviceEntity device = this.lanDeviceDAO.findNotDeletedLanDeviceByMac(macAddress);
        if (device == null) {
            return;
        }
        ParsedRequest parsedRequest = this.parseRequest(request);
        this.eventService.processEvent(device.getLanDeviceId(), "MOTION", parsedRequest.snapshot, "VIDEO", null, parsedRequest.eventDate, parsedRequest.videoClip);
    }

    private ParsedRequest parseRequest(HttpServletRequest request) {
        ParsedRequest parsedRequest;
        block5: {
            log.debug((Object)("start parseRequest(request=" + request.getQueryString() + ")"));
            parsedRequest = new ParsedRequest(this, null);
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            if (!isMultipart) {
                return parsedRequest;
            }
            DiskFileItemFactory fileItemFoctory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fileItemFoctory);
            try {
                List items = upload.parseRequest(request);
                for (FileItem item : items) {
                    if (!"file".equals(item.getFieldName())) continue;
                    if ("image/jpeg".endsWith(item.getContentType())) {
                        parsedRequest.snapshot = item.get();
                        parsedRequest.eventDate = this.extractDate(item.getName());
                        continue;
                    }
                    if (!"video/mpeg".endsWith(item.getContentType())) continue;
                    parsedRequest.videoClip = item.get();
                    parsedRequest.eventDate = this.extractDate(item.getName());
                }
            }
            catch (Exception e) {
                log.debug((Object)("Error occured during extraction camera snapshot (MAC=" + (request != null ? request.getParameter("id") : "null") + "): " + e.getMessage()));
                if (!log.isDebugEnabled()) break block5;
                e.printStackTrace();
            }
        }
        return parsedRequest;
    }

    private Date extractDate(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        String dateString = this.getDateTimePartFromString(text);
        log.debug((Object)("extractDate text = " + text + ", dateString = " + dateString));
        return Utils.parseDate((String)dateString, (String)"yyyyMMdd_HHmmss", null, (TimeZone)TimeZone.getTimeZone("UTC"));
    }

    private String getDateTimePartFromString(String text) {
        Pattern pattern = Pattern.compile(".*([0-9]{8}_[0-9]{6}).*");
        Matcher matcher = pattern.matcher(text);
        String s = "";
        while (matcher.find()) {
            s = matcher.group(1);
        }
        return s;
    }
}

