/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.servlet;

import java.io.IOException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.HttpRequestHandler;
import pl.smartapps.hm.WebViewer.shared.model.DeviceFeatureCode;
import pl.smartapps.hm.WebViewer.shared.model.DeviceProduct;
import pl.smartapps.hm.WebViewer.shared.model.UserFeatureCode;
import pl.smartapps.restserver.db.dao.TransactionDAO;
import pl.smartapps.restserver.db.main.ProductEntity;
import pl.smartapps.restserver.db.main.TransactionEntity;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ProductManagementService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.servlet.PostfinanceServerMock;
import pl.smartapps.restserver.util.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
public class PostfinanceServerMock
implements HttpRequestHandler {
    private static Logger log = Logger.getLogger(PostfinanceServerMock.class);
    private TransactionDAO transactionDAO;
    private ProductManagementService productManagementService;
    private String status = null;
    private Command command = Command.DECLINE_PAYMENT;
    private String serverAddress;
    private ParameterService parameterService;
    private static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$restserver$servlet$PostfinanceServerMock$Command;

    @Autowired
    @Required
    public void setTransactionDAO(TransactionDAO transactionDAO) {
        this.transactionDAO = transactionDAO;
    }

    @Autowired
    @Required
    public void setProductManagementService(ProductManagementService productManagementService) {
        this.productManagementService = productManagementService;
    }

    @Value(value="${lanDevice.serverUrl}")
    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String cmd = request.getParameter("cmd");
        if (cmd != null) {
            this.command = Command.valueOf((String)cmd);
            if (this.command == Command.STATUS) {
                this.processCommand(request, response);
            }
            return;
        }
        if (!this.isRequestAuthentic(request)) {
            this.status = "REQUEST_TAMPERED";
            return;
        }
        try {
            if (!this.verifyRequest(request)) {
                this.status = "REQUEST_INCORRECT";
                return;
            }
        }
        catch (InvalidSessionException e) {
            log.warn((Object)"verifyRequest threw InvalidSessionException");
            e.printStackTrace();
        }
        this.status = "REQUEST_OK";
        this.processCommand(request, response);
    }

    private void sortParamsAsc(String[] paymentParams) {
        Arrays.sort(paymentParams, new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean isRequestAuthentic(HttpServletRequest request) {
        String encodedMessage;
        block4: {
            String[] shaInCaclulationParams = new String[]{"PSPID", "orderId", "amount", "currency", "language", "accepturl", "declineurl", "exceptionurl", "cancelurl"};
            this.sortParamsAsc(shaInCaclulationParams);
            StringBuilder rawMessage = new StringBuilder();
            String[] stringArray = shaInCaclulationParams;
            int n = shaInCaclulationParams.length;
            int n2 = 0;
            while (n2 < n) {
                String paymentParam = stringArray[n2];
                rawMessage.append(paymentParam.toUpperCase());
                rawMessage.append("=");
                String paymentParamValue = request.getParameter(paymentParam);
                if (paymentParamValue == null) {
                    log.warn((Object)("Required payment parameter missing: '" + paymentParam + "'."));
                    return false;
                }
                rawMessage.append(paymentParamValue);
                rawMessage.append(this.parameterService.getParameterValue(ParameterService.ParameterCode.POSTFINANCE_SHA_IN_PASSPHRASE));
                ++n2;
            }
            log.debug((Object)("Raw message: " + rawMessage));
            encodedMessage = null;
            try {
                MessageDigest sha1 = MessageDigest.getInstance("SHA1");
                encodedMessage = PostfinanceServerMock.byteArray2Hex((byte[])sha1.digest(rawMessage.toString().getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                log.warn((Object)("Error when veryfing payment request: " + e.getMessage()));
                if (!log.isDebugEnabled()) break block4;
                e.printStackTrace();
            }
        }
        log.debug((Object)("actual message: " + encodedMessage));
        String expectedMessage = request.getParameter("SHASign");
        log.debug((Object)("expected message: " + expectedMessage));
        return expectedMessage.equals(encodedMessage);
    }

    private static String byteArray2Hex(byte[] hash) {
        Formatter formatter = new Formatter();
        byte[] byArray = hash;
        int n = hash.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            formatter.format("%02x", b);
            ++n2;
        }
        return formatter.toString();
    }

    private boolean verifyRequest(HttpServletRequest request) throws InvalidSessionException {
        String amountFromRequest;
        String pspId = this.parameterService.getParameterValue(ParameterService.ParameterCode.POSTFINANCE_PSP_ID);
        if (!pspId.equals(request.getParameter("PSPID"))) {
            log.warn((Object)"Unexpected PSPID.");
            return false;
        }
        TransactionEntity transaction = this.getTransaction(request);
        if (transaction == null) {
            log.warn((Object)"Unexpected orderId.");
            return false;
        }
        String expectedAmount = String.valueOf(transaction.getAmount().multiply(BigDecimal.valueOf(100L)));
        if (expectedAmount.contains(".")) {
            expectedAmount = expectedAmount.substring(0, expectedAmount.indexOf("."));
        }
        if (!(amountFromRequest = request.getParameter("amount")).equals(expectedAmount)) {
            log.warn((Object)("Unexpected amount value. Expected: " + expectedAmount + ", got: " + amountFromRequest));
            return false;
        }
        ProductEntity premiumProduct = this.productManagementService.getProduct(transaction.getLanDevice().getUser().getId(), DeviceProduct.DeviceProductType.PREMIUM);
        if (premiumProduct == null) {
            log.warn((Object)("Not found premium product for current logged user with userId=" + transaction.getLanDevice().getUser().getId() + "."));
            return false;
        }
        String amount = this.productManagementService.getFeatureValue(premiumProduct.getProductId(), DeviceFeatureCode.AMOUNT);
        String amountFromProduct = amount.replace(".", "");
        if (!amountFromRequest.equals(amountFromProduct)) {
            log.warn((Object)("Unexpected amount value. Expected: " + amountFromProduct + ", got: " + amountFromRequest));
            return false;
        }
        if (!request.getParameter("currency").equals(transaction.getCurrency())) {
            log.warn((Object)"Unexpected currency.");
            return false;
        }
        String currency = this.productManagementService.getUserFeatureValue(transaction.getUser().getId(), UserFeatureCode.CURRENCY);
        if (!request.getParameter("currency").equals(currency)) {
            log.warn((Object)"Unexpected currency.");
            return false;
        }
        String expectedAcceptUrl = "#MainPage;ShowExtendValid=true;PaymentResult=ACCEPT;Id=" + transaction.getLanDevice().getLanDeviceId();
        String acceptUrlFromRequest = this.getUrlTail(request, "accepturl");
        if (!acceptUrlFromRequest.equals(expectedAcceptUrl)) {
            log.warn((Object)("Unexpected accepturl. Expected: " + expectedAcceptUrl + ", got: " + acceptUrlFromRequest));
            return false;
        }
        if (!this.getUrlTail(request, "declineurl").equals("#MainPage;ShowExtendValid=true;PaymentResult=DECLINE;Id=" + transaction.getLanDevice().getLanDeviceId())) {
            log.warn((Object)"Unexpected declineurl.");
            return false;
        }
        if (!this.getUrlTail(request, "exceptionurl").equals("#MainPage;ShowExtendValid=true;PaymentResult=EXCEPTION;Id=" + transaction.getLanDevice().getLanDeviceId())) {
            log.warn((Object)"Unexpected declineurl.");
            return false;
        }
        if (!this.getUrlTail(request, "cancelurl").equals("#MainPage")) {
            log.warn((Object)"Unexpected cancelurl.");
            return false;
        }
        return true;
    }

    private TransactionEntity getTransaction(HttpServletRequest request) {
        String orderId = request.getParameter("orderId");
        if (orderId == null || orderId.isEmpty()) {
            return null;
        }
        if (!orderId.matches("[0-9]{20}")) {
            log.warn((Object)("Unexpected form of orderId: " + orderId + "."));
            return null;
        }
        return this.transactionDAO.findTransactionByIdAndTimestamp(this.getTransacionId(orderId), this.getTransactionTimestamp(orderId));
    }

    private Integer getTransacionId(String orderId) {
        return Integer.parseInt(orderId.substring(14));
    }

    private Date getTransactionTimestamp(String orderId) {
        return Utils.parseDate((String)orderId.substring(0, 14), (String)"yyyyMMddHHmmss");
    }

    private String getUrlTail(HttpServletRequest request, String paramName) {
        String paramValue = request.getParameter(paramName);
        if (paramValue == null) {
            return null;
        }
        if (paramValue.contains("#MainPage")) {
            paramValue = paramValue.substring(paramValue.indexOf("#MainPage"));
        }
        return paramValue;
    }

    /*
     * Exception decompiling
     */
    private void processCommand(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String constructResponse(HttpServletRequest request, Command command) {
        String[] shaOutCaclulationParams = new String[]{"amount", "PM", "orderID", "ACCEPTANCE", "PAYID", "TRXDATE", "CVCCheck", "BRAND", "STATUS", "NCERROR", "currency"};
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("amount", request.getParameter("amount"));
        params.put("PM", "PostFinance e-finance");
        params.put("orderID", request.getParameter("orderId"));
        params.put("ACCEPTANCE", "TEST");
        params.put("PAYID", "11831050");
        params.put("TRXDATE", "09/28/11");
        params.put("CVCCheck", "");
        params.put("BRAND", "PostFinance e-finance");
        params.put("STATUS", this.getStatus(command));
        params.put("NCERROR", "0");
        params.put("currency", request.getParameter("currency"));
        String shaSign = this.calcuateShaSign(shaOutCaclulationParams, params);
        params.put("SHASign", shaSign.toUpperCase());
        StringBuilder content = new StringBuilder();
        for (Map.Entry entry : params.entrySet()) {
            content.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&");
        }
        content.delete(content.length() - 1, content.length());
        return content.toString();
    }

    /*
     * Exception decompiling
     */
    private String getStatus(Command command) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String calcuateShaSign(String[] calculationParams, Map<String, String> params) {
        String encodedMessage;
        block5: {
            this.sortParamsAsc(calculationParams);
            StringBuilder rawMessage = new StringBuilder();
            String[] stringArray = calculationParams;
            int n = calculationParams.length;
            int n2 = 0;
            while (n2 < n) {
                String paramName = stringArray[n2];
                String paramValue = params.get(paramName);
                if (paramValue == null) {
                    log.warn((Object)("Required payment parameter missing: '" + paramName + "'."));
                    return null;
                }
                if (!paramValue.trim().isEmpty()) {
                    rawMessage.append(paramName.toUpperCase());
                    rawMessage.append("=");
                    rawMessage.append(paramValue);
                    rawMessage.append(this.parameterService.getParameterValue(ParameterService.ParameterCode.POSTFINANCE_SHA_OUT_PASSPHRASE));
                }
                ++n2;
            }
            log.debug((Object)("Raw message: " + rawMessage));
            encodedMessage = null;
            try {
                MessageDigest sha1 = MessageDigest.getInstance("SHA1");
                encodedMessage = PostfinanceServerMock.byteArray2Hex((byte[])sha1.digest(rawMessage.toString().getBytes()));
            }
            catch (NoSuchAlgorithmException e) {
                log.warn((Object)("Error when veryfing payment request: " + e.getMessage()));
                if (!log.isDebugEnabled()) break block5;
                e.printStackTrace();
            }
        }
        log.debug((Object)("actual message: " + encodedMessage));
        return encodedMessage;
    }

    private void processPayment(HttpServletRequest request, Command command) throws ClientProtocolException, IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost httpPost = new HttpPost(String.valueOf(this.serverAddress) + "/payment");
        StringEntity entity = new StringEntity(this.constructResponse(request, command), "application/x-www-form-urlencoded", "UTF-8");
        httpPost.setEntity((HttpEntity)entity);
        client.execute((HttpUriRequest)httpPost);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$restserver$servlet$PostfinanceServerMock$Command() {
        if ($SWITCH_TABLE$pl$smartapps$restserver$servlet$PostfinanceServerMock$Command != null) {
            return $SWITCH_TABLE$pl$smartapps$restserver$servlet$PostfinanceServerMock$Command;
        }
        int[] nArray = new int[Command.values().length];
        try {
            nArray[Command.ACCEPT_PAYMENT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Command.CANCEL_PAYMENT.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Command.DECLINE_PAYMENT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Command.EXCEPTION_PAYMENT.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Command.STATUS.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$pl$smartapps$restserver$servlet$PostfinanceServerMock$Command = nArray;
        return nArray;
    }
}

