/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.servlet;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.HttpRequestHandler;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.PaymentService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.servlet.PostFinancePaymentServlet;
import pl.smartapps.restserver.servlet.ServletUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class PostFinancePaymentServlet
implements HttpRequestHandler {
    private static final Set<PaymentParam> paymentParamsSupportSha = new /* Unavailable Anonymous Inner Class!! */;
    private static Logger log = Logger.getLogger(PostFinancePaymentServlet.class);
    private PaymentService paymentService;
    private ParameterService parameterService;

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Transactional
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug((Object)("start handleRequest(request=" + request + ", response=" + response + ")"));
        if (!this.fromTrustedIPAddress(request)) {
            log.warn((Object)("Request from an untrusted IP address: " + ServletUtils.toString((HttpServletRequest)request, (String)", ")));
            return;
        }
        Map params = this.extractParams(request);
        if (!this.verifyRequest(params)) {
            log.warn((Object)("Tampred payment request: " + ServletUtils.toString((HttpServletRequest)request, (String)", ")));
            return;
        }
        String status = "9".equals(params.get(PaymentParam.STATUS)) ? "success" : (String)params.get(PaymentParam.STATUS);
        try {
            this.paymentService.processPaymentNotification((String)params.get(PaymentParam.ORDERID), status, (String)params.get(PaymentParam.PAYID), null, ServletUtils.toString((HttpServletRequest)request, (String)", "));
        }
        catch (InvalidSessionException e) {
            log.warn((Object)("PostFinance payment was successful, but server got InvalidSessionException while trying to change lan device product. Please correct it manualy ASAP (user paid for it). Transaction details: " + params.toString()));
        }
    }

    private String getPaymentParamValue(HttpServletRequest request, PaymentParam paymentParam) {
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(paymentParam.name())) continue;
            String[] paramValue = (String[])entry.getValue();
            return paramValue == null || paramValue.length == 0 ? null : paramValue[0];
        }
        return null;
    }

    private boolean verifyRequest(Map<PaymentParam, String> params) {
        try {
            ArrayList<PaymentParam> paramNames = new ArrayList<PaymentParam>(params.keySet());
            Collections.sort(paramNames, new /* Unavailable Anonymous Inner Class!! */);
            StringBuilder rawMessage = new StringBuilder();
            String shaOutPassphrase = this.parameterService.getParameterValue(ParameterService.ParameterCode.POSTFINANCE_SHA_OUT_PASSPHRASE);
            for (PaymentParam paramName : paramNames) {
                String paramValue = params.get(paramName);
                if (paramValue == null || paramValue.length() <= 0 || !paymentParamsSupportSha.contains(paramName)) continue;
                rawMessage.append(paramName.name()).append("=").append(paramValue).append(shaOutPassphrase);
            }
            log.debug((Object)("rawMessage: " + rawMessage));
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            String encodedMessage = PostFinancePaymentServlet.byteArray2Hex((byte[])sha1.digest(rawMessage.toString().getBytes())).toUpperCase();
            log.debug((Object)("message:  " + encodedMessage));
            log.debug((Object)("expected: " + params.get(PaymentParam.SHASIGN)));
            return encodedMessage.equals(params.get(PaymentParam.SHASIGN));
        }
        catch (NoSuchAlgorithmException e) {
            log.warn((Object)("Error veryfing payment request: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return false;
        }
    }

    private static String byteArray2Hex(byte[] hash) {
        Formatter formatter = new Formatter();
        byte[] byArray = hash;
        int n = hash.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            formatter.format("%02x", b);
            ++n2;
        }
        return formatter.toString();
    }

    private Map<PaymentParam, String> extractParams(HttpServletRequest request) {
        HashMap<PaymentParam, String> params = new HashMap<PaymentParam, String>();
        PaymentParam[] paymentParamArray = PaymentParam.values();
        int n = paymentParamArray.length;
        int n2 = 0;
        while (n2 < n) {
            PaymentParam paymentParam = paymentParamArray[n2];
            params.put(paymentParam, this.getPaymentParamValue(request, paymentParam));
            ++n2;
        }
        return params;
    }

    private boolean fromTrustedIPAddress(HttpServletRequest request) {
        String trustedIPAddresses = this.parameterService.getParameterValue(ParameterService.ParameterCode.POSTFINANCE_TRUSTED_IP_ADDRESSES);
        return trustedIPAddresses.contains(request.getRemoteAddr());
    }
}

