/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.HttpRequestHandler;
import pl.smartapps.containerserver.HttpClientFactory;

public class GetBrowserLanguageServlet
implements HttpRequestHandler {
    private static final long serialVersionUID = 6560171562324177699L;
    private HttpClientFactory httpClientFactory;

    @Autowired
    @Required
    public void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String header = request.getHeader("Accept-Language");
        response.setContentType("text/plain");
        String lang = header.substring(0, 2);
        String country = "";
        country = header.length() >= 5 && header.charAt(2) == '-' ? header.substring(3, 5) : lang;
        String remoteIpAddress = this.getRemoteAddress(request);
        if (remoteIpAddress != null) {
            String geoIPResponse;
            String[] geoIPResponseElems;
            HttpClient client = this.httpClientFactory.getHttpClient();
            client.getParams().setParameter("http.socket.timeout", (Object)new Integer(3000));
            client.getParams().setParameter("http.connection.timeout", (Object)new Integer(3000));
            HttpGet httpGet = new HttpGet("http://api.geoio.com/q.php?key=qKSqK4TqKI54ZKAB&qt=geoip&d=semi&q=" + remoteIpAddress);
            HttpResponse httpResponse = client.execute((HttpUriRequest)httpGet);
            if (httpResponse.getStatusLine().getStatusCode() == 200 && (geoIPResponseElems = (geoIPResponse = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)"UTF-8")).split(";")).length == 7) {
                country = geoIPResponseElems[6];
            }
        }
        lang = String.valueOf(lang) + "-" + country;
        response.getOutputStream().write(lang.getBytes());
    }

    private String getRemoteAddress(HttpServletRequest request) {
        String address = this.getRemoteAddressFromHeader(request);
        address = address != null ? address : request.getRemoteAddr();
        address = this.isPrivateIp(address) ? null : address;
        return address;
    }

    private boolean isPrivateIp(String ipAddress) {
        InetAddress ia = null;
        try {
            InetAddress ad = InetAddress.getByName(ipAddress);
            byte[] ip = ad.getAddress();
            ia = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        boolean isPrivate = ia.isSiteLocalAddress() || ia.isLinkLocalAddress() || ia.isLoopbackAddress();
        return isPrivate;
    }

    private String getRemoteAddressFromHeader(HttpServletRequest request) {
        String address = request.getHeader("X-Forwarded-For");
        if (address != null) {
            String[] addressesFromHeader = address.split(",");
            address = addressesFromHeader[0];
        }
        return address;
    }
}

