/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.servlet;

import com.allen_sauer.gwt.log.client.Log;
import java.io.IOException;
import java.text.SimpleDateFormat;
import javax.annotation.PostConstruct;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.HttpRequestHandler;
import pl.smartapps.restserver.db.dao.EventDAO;
import pl.smartapps.restserver.db.main.EventEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.service.EventsFilesController;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.EventsFilesControllerFactory;

public class EventImageServlet
implements HttpRequestHandler {
    private static Logger log = Logger.getLogger(EventImageServlet.class);
    @Autowired
    private EventDAO eventDAO;
    @Autowired
    private LanDeviceService lanDeviceService;
    @Autowired
    private AuthenticationUtils authUtils;
    @Autowired
    private EventsFilesControllerFactory eventsFilesControllerFactory;
    private EventsFilesController eventsFilesController;

    public void setEventDAO(EventDAO eventDAO) {
        this.eventDAO = eventDAO;
    }

    public void setLanDeviceService(LanDeviceService lanDeviceService) {
        this.lanDeviceService = lanDeviceService;
    }

    public void setAuthUtils(AuthenticationUtils authUtils) {
        this.authUtils = authUtils;
    }

    public void setEventsFilesController(EventsFilesController eventsFilesController) {
        this.eventsFilesController = eventsFilesController;
    }

    @PostConstruct
    public void init() {
        this.setEventsFilesController(this.eventsFilesControllerFactory.getEventsFilesController());
    }

    @Transactional
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.authUtils.isLoggedIn()) {
            Log.warn((String)"SC_UNAUTHORIZED");
            response.setStatus(401);
            return;
        }
        String eventId = request.getParameter("eventId");
        if (eventId == null || eventId.trim().length() == 0) {
            Log.warn((String)"SC_NOT_FOUND: eventId = null or empty");
            response.setStatus(404);
            return;
        }
        EventEntity event = this.eventDAO.findEventById(Integer.valueOf(Integer.parseInt(eventId)));
        try {
            if (event == null || !this.canCurrentUserAccessEvent(event)) {
                Log.warn((String)("SC_NOT_FOUND: eventId = " + eventId));
                response.setStatus(404);
                return;
            }
        }
        catch (InvalidSessionException e) {
            Log.warn((String)"SC_UNAUTHORIZED");
            response.setStatus(401);
            return;
        }
        String filename = this.getSnapshotFilename(event);
        String cameraName = event.getLanDevice().getNameForUserId(this.authUtils.getCurrentUserId());
        String dateAndTime = filename.substring(0, filename.indexOf("_"));
        String ext = filename.substring(filename.indexOf(".") + 1);
        String saveFileName = "hm_" + cameraName + "_" + dateAndTime + "." + ext;
        this.eventsFilesController.downloadImage(request, response, event, filename, saveFileName);
    }

    private boolean canCurrentUserAccessEvent(EventEntity event) throws InvalidSessionException {
        Integer lanDeviceId = event.getLanDevice() != null ? event.getLanDevice().getLanDeviceId() : null;
        LanDeviceEntity lanDevice = this.lanDeviceService.getLanDeviceByIdWithAccessVerification(lanDeviceId);
        return lanDevice != null;
    }

    private String getSnapshotFilename(EventEntity event) {
        return String.valueOf(new SimpleDateFormat("yyyyMMddHHmmss").format(event.getDateEvent())) + "_" + event.getEventId() + ".jpg";
    }
}

