/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.HttpRequestHandler;
import pl.smartapps.restserver.db.dao.DebuglogDAO;
import pl.smartapps.restserver.db.main.DebuglogEntity;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.Debuglog;
import pl.smartapps.restserver.service.impl.JsonDebuglogMapper;
import pl.smartapps.restserver.servlet.DebuglogServlet;
import pl.smartapps.restserver.util.Utils;

public class DebuglogServlet
implements HttpRequestHandler {
    private static Logger log = Logger.getLogger(DebuglogServlet.class);
    private JsonDebuglogMapper mapper;
    private DebuglogDAO debuglogDAO;
    private AuthenticationUtils authUtils;

    @Autowired
    @Required
    public void setMapper(JsonDebuglogMapper mapper) {
        this.mapper = mapper;
    }

    @Autowired
    @Required
    public void setDebuglogDAO(DebuglogDAO debuglogDAO) {
        this.debuglogDAO = debuglogDAO;
    }

    @Autowired
    @Required
    public void setAuthUtils(AuthenticationUtils authUtils) {
        this.authUtils = authUtils;
    }

    @Transactional
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug((Object)"start DebuglogServlet.handleRequest");
        List debuglogs = this.mapper.map((InputStream)request.getInputStream());
        if (debuglogs == null || debuglogs.isEmpty()) {
            return;
        }
        for (Debuglog debuglog : debuglogs) {
            DebuglogEntity debuglogEntity = this.createEntity(debuglog);
            if (this.debuglogDAO.createDebuglog(debuglogEntity) != null) continue;
            log.warn((Object)("Debuglog " + debuglogEntity + " was not saved."));
        }
    }

    private DebuglogEntity createEntity(Debuglog debuglog) {
        DebuglogEntity entity = new DebuglogEntity();
        entity.setLoggerName(debuglog.getLoggerName());
        LogLevel logLevel = this.parseLogLevel(debuglog.getLogLevel());
        entity.setLogLevel(logLevel == null ? null : logLevel.name());
        entity.setNdc(debuglog.getNdc());
        entity.setMessage(debuglog.getMessage());
        entity.setThread(debuglog.getThread());
        entity.setTimestamp(Utils.buildDate((Integer)debuglog.getTimestampSec(), (Integer)debuglog.getTimestampUSec()));
        entity.setFile(debuglog.getFile());
        entity.setLine(debuglog.getLine().intValue());
        entity.setJsessionId(this.authUtils.getCurrentSubject().getSession().getId().toString());
        entity.setUsername(this.authUtils.getCurrentUser().getUsername());
        return entity;
    }

    private LogLevel parseLogLevel(Integer value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return LogLevel.TRACE;
            }
            case 10000: {
                return LogLevel.DEBUG;
            }
            case 20000: {
                return LogLevel.INFO;
            }
            case 30000: {
                return LogLevel.WARN;
            }
            case 40000: {
                return LogLevel.ERROR;
            }
            case 50000: {
                return LogLevel.FATAL;
            }
            case 60000: {
                return LogLevel.OFF;
            }
        }
        log.warn((Object)("Unknown log level: " + value + "."));
        return null;
    }
}

