/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.servlet;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.HttpRequestHandler;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.PaymentService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.servlet.DatatransPaymentServlet;
import pl.smartapps.restserver.servlet.ServletUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DatatransPaymentServlet
implements HttpRequestHandler {
    private static Logger log = Logger.getLogger(DatatransPaymentServlet.class);
    private PaymentService paymentService;
    private ParameterService parameterService;

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Transactional
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug((Object)("start handleRequest(request=" + request + ", response=" + response + ")"));
        Map params = this.extractParams(request);
        if (!this.verifyRequest(params)) {
            log.warn((Object)("Tampred payment request: " + ServletUtils.toString((HttpServletRequest)request, (String)", ")));
            return;
        }
        String status = "success".equals(params.get(PaymentParam.STATUS)) ? "success" : (String)params.get(PaymentParam.ERRORCODE);
        try {
            this.paymentService.processPaymentNotification((String)params.get(PaymentParam.REFNO), status, (String)params.get(PaymentParam.UPPTRANSACTIONID), (String)params.get(PaymentParam.PMETHOD), ServletUtils.toString((HttpServletRequest)request, (String)", "));
        }
        catch (InvalidSessionException e) {
            log.warn((Object)("Datatrans payment was successful, but server got InvalidSessionException while trying to change lan device product. Please correct it manualy ASAP (user paid for it). Transaction details: " + params.toString()));
        }
    }

    private String getPaymentParamValue(HttpServletRequest request, PaymentParam paymentParam) {
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(paymentParam.name())) continue;
            String[] paramValue = (String[])entry.getValue();
            return paramValue == null || paramValue.length == 0 ? null : paramValue[0];
        }
        return null;
    }

    private boolean verifyRequest(Map<PaymentParam, String> params) {
        block6: {
            block5: {
                String status = params.get(PaymentParam.STATUS);
                if (params.get(PaymentParam.SIGN2) != null || !status.equals("error")) break block5;
                return true;
            }
            try {
                String rawMessage = this.buildRawMessage(params.get(PaymentParam.AMOUNT), params.get(PaymentParam.CURRENCY), params.get(PaymentParam.UPPTRANSACTIONID));
                log.debug((Object)("rawMessage: " + rawMessage));
                String sign2 = this.parameterService.getParameterValue(ParameterService.ParameterCode.DATATRANS_SIGN2);
                byte[] keyBytes = DatatransPaymentServlet.hexStringToByteArray((String)sign2);
                SecretKeySpec key = new SecretKeySpec(keyBytes, 0, keyBytes.length, "HmacMD5");
                Mac mac = Mac.getInstance("HmacMD5");
                mac.init(key);
                String encodedMessage = DatatransPaymentServlet.byteArray2Hex((byte[])mac.doFinal(rawMessage.getBytes()));
                log.debug((Object)("message:  " + encodedMessage));
                log.debug((Object)("expected: " + params.get(PaymentParam.SIGN2)));
                return encodedMessage.equals(params.get(PaymentParam.SIGN2));
            }
            catch (NoSuchAlgorithmException e) {
                log.warn((Object)("Error veryfing payment request: " + e.getMessage()));
                if (log.isDebugEnabled()) {
                    e.printStackTrace();
                }
            }
            catch (InvalidKeyException e) {
                log.warn((Object)("Error veryfing payment request: " + e.getMessage()));
                if (!log.isDebugEnabled()) break block6;
                e.printStackTrace();
            }
        }
        return false;
    }

    private String buildRawMessage(String amount, String currency, String transactionId) {
        String datatransId = this.parameterService.getParameterValue(ParameterService.ParameterCode.DATATRANS_MERCHANT_ID);
        return String.valueOf(datatransId) + amount + currency + transactionId;
    }

    private static String byteArray2Hex(byte[] hash) {
        Formatter formatter = new Formatter();
        byte[] byArray = hash;
        int n = hash.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            formatter.format("%02x", b);
            ++n2;
        }
        return formatter.toString();
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    private Map<PaymentParam, String> extractParams(HttpServletRequest request) {
        HashMap<PaymentParam, String> params = new HashMap<PaymentParam, String>();
        PaymentParam[] paymentParamArray = PaymentParam.values();
        int n = paymentParamArray.length;
        int n2 = 0;
        while (n2 < n) {
            PaymentParam paymentParam = paymentParamArray[n2];
            params.put(paymentParam, this.getPaymentParamValue(request, paymentParam));
            ++n2;
        }
        return params;
    }
}

