/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.servlet;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.HttpRequestHandler;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.service.EventService;
import pl.smartapps.restserver.servlet.VivotekMotionDetectionEventServlet;
import pl.smartapps.restserver.util.Utils;

public class ComproMotionDetectionEventServlet
implements HttpRequestHandler {
    private static Logger log = Logger.getLogger(VivotekMotionDetectionEventServlet.class);
    private EventService eventService;
    private LanDeviceDAO lanDeviceDAO;

    @Autowired
    @Required
    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    @Autowired
    @Required
    public void setLanDeviceDAO(LanDeviceDAO lanDeviceDAO) {
        this.lanDeviceDAO = lanDeviceDAO;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String senderMacAddress = this.getMacAddress(request);
        String parameters = request.getParameter("Msg");
        String eventType = this.getEventType(parameters);
        Date date = this.getDate(parameters);
        LanDeviceEntity lanDeviceEntity = this.lanDeviceDAO.findNotDeletedLanDeviceByMac(senderMacAddress);
        this.eventService.processEvent(lanDeviceEntity.getLanDeviceId(), this.mapEventType(eventType), null, "VIDEO", null, date, null);
    }

    private String mapEventType(String eventType) {
        if (eventType.equalsIgnoreCase("AudioDetect")) {
            return "AUDIO";
        }
        return eventType;
    }

    private Date getDate(String parameters) {
        String dateString = parameters.substring(parameters.indexOf(":") + 1);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmss");
        Date result = null;
        try {
            result = format.parse(dateString);
        }
        catch (ParseException e) {
            log.debug((Object)("cannot read date format from string: " + dateString));
        }
        return result;
    }

    private String getEventType(String parameters) {
        return parameters.substring(0, parameters.indexOf(","));
    }

    private String getMacAddress(HttpServletRequest request) {
        String path = request.getRequestURI();
        int macPosition = path.lastIndexOf("/");
        if (macPosition < 0 || path.length() - macPosition - 1 != 12) {
            log.debug((Object)("MAC address not found in path: " + path));
            return null;
        }
        String rawMacAddress = path.substring(macPosition + 1);
        return Utils.formatMacAddress((String)rawMacAddress);
    }
}

