/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.HttpRequestHandler;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.ChangePasswordResponse;
import pl.smartapps.restserver.service.UserService;

public class ChangePasswordServlet
implements HttpRequestHandler {
    private static final String CODE = "code";
    private static final String PASSWORD = "password";
    private static final String CONFIRM_PASSWORD = "confirmPassword";
    private UserService userService;
    private UserDAO userDAO;

    @Autowired
    @Required
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Autowired
    @Required
    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String code = request.getParameter(CODE);
        if (code == null) {
            response.setStatus(404);
            return;
        }
        UserEntity foundUser = this.userDAO.findUserByChangePasswordCode(code);
        if (foundUser == null) {
            request.getRequestDispatcher("/jsp/InvalidChangePasswordCode.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String password = request.getParameter(PASSWORD);
        String confirmPassword = request.getParameter(CONFIRM_PASSWORD);
        if (password == null || confirmPassword == null) {
            request.getRequestDispatcher("/jsp/ChangePassword.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        ChangePasswordResponse changePasswordResponse = this.userService.changePasswordByCode(code, password, confirmPassword);
        if (changePasswordResponse.status == ChangePasswordResponse.ChangePasswordStatus.SUCCESS) {
            request.getRequestDispatcher("/jsp/PasswordChanged.jsp").forward((ServletRequest)request, (ServletResponse)response);
        } else {
            request.setAttribute("status", (Object)changePasswordResponse.status.toString());
            request.getRequestDispatcher("/jsp/ChangePassword.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

