/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.HttpRequestHandler;
import pl.smartapps.restserver.service.VideoStreamService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;

public class CameraPreviewServlet
implements HttpRequestHandler {
    @Autowired
    private VideoStreamService videoStreamService;

    @Transactional
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String lanDeviceId = request.getParameter("lanDeviceId");
        if (lanDeviceId == null || lanDeviceId.trim().length() == 0) {
            response.setStatus(404);
            return;
        }
        String resolution = request.getParameter("resolution");
        if (resolution == null) {
            resolution = "320x240";
        }
        try {
            byte[] snapshot = this.videoStreamService.getCurrentSnapshot(Integer.valueOf(Integer.parseInt(lanDeviceId)), resolution);
            if (snapshot != null) {
                response.setContentType("image/jpeg");
                response.setContentLength(snapshot.length);
                ServletOutputStream out = response.getOutputStream();
                out.write(snapshot);
                out.close();
            }
        }
        catch (NumberFormatException e) {
            response.setStatus(404);
            return;
        }
        catch (InvalidSessionException e) {
            response.setStatus(401);
            return;
        }
    }
}

