/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.servlet;

import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.shiro.util.ThreadContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.HttpRequestHandler;
import pl.smartapps.restserver.service.EventService;

public class BrickcomMotionDetectionEventServlet
implements HttpRequestHandler {
    private Logger log = Logger.getLogger(BrickcomMotionDetectionEventServlet.class);
    private EventService eventService;

    @Autowired
    @Required
    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.debug((Object)"start BrickcomMotionDetectionEventServlet.handleRequest");
        Integer lanDeviceId = (Integer)ThreadContext.get((Object)"lanDecviceId");
        Date eventDate = (Date)ThreadContext.get((Object)"lanDeviceEventDate");
        String eventType = (String)ThreadContext.get((Object)"lanDeviceEventType");
        if (eventType == null || eventType.equalsIgnoreCase("PIR")) {
            eventType = "MOTION";
        }
        byte[] snapshot = (byte[])ThreadContext.get((Object)"lanDeviceSnapshot");
        byte[] videoClip = (byte[])ThreadContext.get((Object)"lanDeviceVideoClip");
        this.eventService.processEvent(lanDeviceId, eventType, snapshot, "VIDEO", null, eventDate, videoClip);
    }
}

