/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.HttpRequestHandler;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.db.main.UserEntity;

public class AccountActivationServlet
implements HttpRequestHandler {
    private UserDAO userDAO;

    @Autowired
    @Required
    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    @Transactional
    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String activationCode = request.getParameter("code");
        if (activationCode == null) {
            response.setStatus(404);
            return;
        }
        String userId = activationCode.substring(activationCode.indexOf("_") + 1);
        Integer id = null;
        try {
            id = Integer.parseInt(userId);
        }
        catch (NumberFormatException e) {
            response.setStatus(404);
            return;
        }
        if (activationCode.indexOf("_") == -1) {
            response.setStatus(404);
            return;
        }
        String code = activationCode.substring(0, activationCode.indexOf("_"));
        if (code.isEmpty()) {
            response.setStatus(404);
            return;
        }
        UserEntity foundUserById = this.userDAO.findUserById(id);
        UserEntity foundUserByCode = this.userDAO.findUserByActivationCode(code);
        if (foundUserById == null || userId.length() != 6 || foundUserById.getActivationCode() != null && !code.equals(foundUserById.getActivationCode()) || foundUserById.getActivationCode() == null && foundUserByCode != null) {
            request.getRequestDispatcher("/jsp/InvalidActivationCode.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (foundUserById.getActivationCode() == null && foundUserByCode == null) {
            request.getRequestDispatcher("/jsp/AccountAlreadyActivated.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        foundUserByCode.setActivationCode(null);
        if (this.userDAO.updateUser(foundUserByCode) == null) {
            request.getRequestDispatcher("/jsp/ErrorDuringActivation.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        request.getRequestDispatcher("/jsp/ActivationSuccess.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }
}

