/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.servlet;

import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.shiro.util.ThreadContext;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.service.EventService;
import pl.smartapps.restserver.servlet.VivotekMotionDetectionEventServlet;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={VivotekMotionDetectionEventServlet.class, ServletFileUpload.class, FileItemFactory.class, ThreadContext.class})
public class VivotekMotionDetectionEventServletTests {
    private VivotekMotionDetectionEventServlet servlet;
    private EventService eventService;
    private LanDeviceDAO lanDeviceDAO;
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;

    @Before
    public void setUp() {
        this.servlet = new VivotekMotionDetectionEventServlet();
        this.eventService = (EventService)PowerMock.createMock(EventService.class);
        this.servlet.setEventService(this.eventService);
        this.lanDeviceDAO = (LanDeviceDAO)PowerMock.createMock(LanDeviceDAO.class);
        this.servlet.setLanDeviceDAO(this.lanDeviceDAO);
        this.servletRequest = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        this.servletResponse = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        PowerMock.mockStatic(ServletFileUpload.class);
    }

    @Test
    public void testRequestWithSnapshot() throws Exception {
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn((Object)"00:02:D1:09:D9:37");
        EasyMock.expect((Object)this.servletRequest.getQueryString()).andReturn((Object)"");
        LanDeviceEntity device = new LanDeviceEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:09:D9:37")).andReturn((Object)device);
        DiskFileItemFactory fileItemFactory = (DiskFileItemFactory)PowerMock.createMock(DiskFileItemFactory.class);
        PowerMock.expectNew(DiskFileItemFactory.class, (Object[])new Object[0]).andReturn((Object)fileItemFactory);
        ServletFileUpload upload = (ServletFileUpload)PowerMock.createMock(ServletFileUpload.class);
        PowerMock.expectNew(ServletFileUpload.class, (Object[])new Object[]{fileItemFactory}).andReturn((Object)upload);
        EasyMock.expect((Object)ServletFileUpload.isMultipartContent((HttpServletRequest)this.servletRequest)).andReturn((Object)true);
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
        FileItem item1 = (FileItem)PowerMock.createMock(FileItem.class);
        fileItems.add(item1);
        FileItem item2 = (FileItem)PowerMock.createMock(FileItem.class);
        fileItems.add(item2);
        EasyMock.expect((Object)upload.parseRequest(this.servletRequest)).andReturn(fileItems);
        EasyMock.expect((Object)item1.getFieldName()).andReturn((Object)"form");
        EasyMock.expect((Object)item2.getFieldName()).andReturn((Object)"file");
        EasyMock.expect((Object)item2.getContentType()).andReturn((Object)"image/jpeg");
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)item2.get()).andReturn((Object)snapshot);
        EasyMock.expect((Object)item2.getName()).andReturn((Object)"0002D109D937_20120220_115756M.jpg");
        Date eventDate = Utils.constructDate((int)2012, (int)2, (int)20, (int)12, (int)57, (int)56);
        EasyMock.expect((Object)this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, eventDate, null)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.servletRequest, this.servletResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testRequestWithVideoClip() throws Exception {
        EasyMock.expect((Object)this.servletRequest.getQueryString()).andReturn((Object)"");
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn((Object)"00:02:D1:09:D9:37");
        LanDeviceEntity device = new LanDeviceEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:09:D9:37")).andReturn((Object)device);
        DiskFileItemFactory fileItemFactory = (DiskFileItemFactory)PowerMock.createMock(DiskFileItemFactory.class);
        PowerMock.expectNew(DiskFileItemFactory.class, (Object[])new Object[0]).andReturn((Object)fileItemFactory);
        ServletFileUpload upload = (ServletFileUpload)PowerMock.createMock(ServletFileUpload.class);
        PowerMock.expectNew(ServletFileUpload.class, (Object[])new Object[]{fileItemFactory}).andReturn((Object)upload);
        EasyMock.expect((Object)ServletFileUpload.isMultipartContent((HttpServletRequest)this.servletRequest)).andReturn((Object)true);
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
        FileItem item1 = (FileItem)PowerMock.createMock(FileItem.class);
        fileItems.add(item1);
        FileItem item2 = (FileItem)PowerMock.createMock(FileItem.class);
        fileItems.add(item2);
        EasyMock.expect((Object)upload.parseRequest(this.servletRequest)).andReturn(fileItems);
        EasyMock.expect((Object)item1.getFieldName()).andReturn((Object)"form");
        EasyMock.expect((Object)item2.getFieldName()).andReturn((Object)"file");
        EasyMock.expect((Object)item2.getContentType()).andReturn((Object)"video/mpeg").times(2);
        byte[] videoClip = new byte[5];
        EasyMock.expect((Object)item2.get()).andReturn((Object)videoClip);
        EasyMock.expect((Object)item2.getName()).andReturn((Object)"0002D109D937_20120220_120012.mp4");
        Date eventDate = Utils.constructDate((int)2012, (int)2, (int)20, (int)13, (int)0, (int)12);
        EasyMock.expect((Object)this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, eventDate, videoClip)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.servletRequest, this.servletResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testMacWithColons() throws Exception {
        EasyMock.expect((Object)this.servletRequest.getQueryString()).andReturn((Object)"");
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn((Object)"00:02:D1:09:D9:37");
        LanDeviceEntity device = new LanDeviceEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:09:D9:37")).andReturn((Object)device);
        DiskFileItemFactory fileItemFactory = (DiskFileItemFactory)PowerMock.createMock(DiskFileItemFactory.class);
        PowerMock.expectNew(DiskFileItemFactory.class, (Object[])new Object[0]).andReturn((Object)fileItemFactory);
        ServletFileUpload upload = (ServletFileUpload)PowerMock.createMock(ServletFileUpload.class);
        PowerMock.expectNew(ServletFileUpload.class, (Object[])new Object[]{fileItemFactory}).andReturn((Object)upload);
        EasyMock.expect((Object)ServletFileUpload.isMultipartContent((HttpServletRequest)this.servletRequest)).andReturn((Object)true);
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
        FileItem item1 = (FileItem)PowerMock.createMock(FileItem.class);
        fileItems.add(item1);
        FileItem item2 = (FileItem)PowerMock.createMock(FileItem.class);
        fileItems.add(item2);
        EasyMock.expect((Object)upload.parseRequest(this.servletRequest)).andReturn(fileItems);
        EasyMock.expect((Object)item1.getFieldName()).andReturn((Object)"form");
        EasyMock.expect((Object)item2.getFieldName()).andReturn((Object)"file");
        EasyMock.expect((Object)item2.getContentType()).andReturn((Object)"image/jpeg");
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)item2.get()).andReturn((Object)snapshot);
        EasyMock.expect((Object)item2.getName()).andReturn((Object)"evt20120220_115756.log");
        Date eventDate = Utils.constructDate((int)2012, (int)2, (int)20, (int)12, (int)57, (int)56);
        EasyMock.expect((Object)this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, eventDate, null)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.servletRequest, this.servletResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testMacWithDashes() throws Exception {
        EasyMock.expect((Object)this.servletRequest.getQueryString()).andReturn((Object)"");
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn((Object)"00-02-D1-09-D9-37");
        LanDeviceEntity device = new LanDeviceEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:09:D9:37")).andReturn((Object)device);
        DiskFileItemFactory fileItemFactory = (DiskFileItemFactory)PowerMock.createMock(DiskFileItemFactory.class);
        PowerMock.expectNew(DiskFileItemFactory.class, (Object[])new Object[0]).andReturn((Object)fileItemFactory);
        ServletFileUpload upload = (ServletFileUpload)PowerMock.createMock(ServletFileUpload.class);
        PowerMock.expectNew(ServletFileUpload.class, (Object[])new Object[]{fileItemFactory}).andReturn((Object)upload);
        EasyMock.expect((Object)ServletFileUpload.isMultipartContent((HttpServletRequest)this.servletRequest)).andReturn((Object)true);
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
        FileItem item1 = (FileItem)PowerMock.createMock(FileItem.class);
        fileItems.add(item1);
        FileItem item2 = (FileItem)PowerMock.createMock(FileItem.class);
        fileItems.add(item2);
        EasyMock.expect((Object)upload.parseRequest(this.servletRequest)).andReturn(fileItems);
        EasyMock.expect((Object)item1.getFieldName()).andReturn((Object)"form");
        EasyMock.expect((Object)item2.getFieldName()).andReturn((Object)"file");
        EasyMock.expect((Object)item2.getContentType()).andReturn((Object)"image/jpeg");
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)item2.get()).andReturn((Object)snapshot);
        EasyMock.expect((Object)item2.getName()).andReturn((Object)"0002D109D937_20120220_115756M.jpg");
        Date eventDate = Utils.constructDate((int)2012, (int)2, (int)20, (int)12, (int)57, (int)56);
        EasyMock.expect((Object)this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, eventDate, null)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.servletRequest, this.servletResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testMacWithoutAnySeparators() throws Exception {
        EasyMock.expect((Object)this.servletRequest.getQueryString()).andReturn((Object)"");
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn((Object)"0002D109D937");
        LanDeviceEntity device = new LanDeviceEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:09:D9:37")).andReturn((Object)device);
        DiskFileItemFactory fileItemFactory = (DiskFileItemFactory)PowerMock.createMock(DiskFileItemFactory.class);
        PowerMock.expectNew(DiskFileItemFactory.class, (Object[])new Object[0]).andReturn((Object)fileItemFactory);
        ServletFileUpload upload = (ServletFileUpload)PowerMock.createMock(ServletFileUpload.class);
        PowerMock.expectNew(ServletFileUpload.class, (Object[])new Object[]{fileItemFactory}).andReturn((Object)upload);
        EasyMock.expect((Object)ServletFileUpload.isMultipartContent((HttpServletRequest)this.servletRequest)).andReturn((Object)true);
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
        FileItem item1 = (FileItem)PowerMock.createMock(FileItem.class);
        fileItems.add(item1);
        FileItem item2 = (FileItem)PowerMock.createMock(FileItem.class);
        fileItems.add(item2);
        EasyMock.expect((Object)upload.parseRequest(this.servletRequest)).andReturn(fileItems);
        EasyMock.expect((Object)item1.getFieldName()).andReturn((Object)"form");
        EasyMock.expect((Object)item2.getFieldName()).andReturn((Object)"file");
        EasyMock.expect((Object)item2.getContentType()).andReturn((Object)"image/jpeg");
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)item2.get()).andReturn((Object)snapshot);
        EasyMock.expect((Object)item2.getName()).andReturn((Object)"0002D109D937_20120220_115756M.jpg");
        Date eventDate = Utils.constructDate((int)2012, (int)2, (int)20, (int)12, (int)57, (int)56);
        EasyMock.expect((Object)this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, eventDate, null)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.servletRequest, this.servletResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testForUnknownDevice() throws Exception {
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn((Object)"00:02:D1:09:D9:37");
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:09:D9:37")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.servletRequest, this.servletResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testNoneFileItems() throws Exception {
        EasyMock.expect((Object)this.servletRequest.getQueryString()).andReturn((Object)"");
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn((Object)"00:02:D1:09:D9:37");
        LanDeviceEntity device = new LanDeviceEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:09:D9:37")).andReturn((Object)device);
        DiskFileItemFactory fileItemFactory = (DiskFileItemFactory)PowerMock.createMock(DiskFileItemFactory.class);
        PowerMock.expectNew(DiskFileItemFactory.class, (Object[])new Object[0]).andReturn((Object)fileItemFactory);
        ServletFileUpload upload = (ServletFileUpload)PowerMock.createMock(ServletFileUpload.class);
        PowerMock.expectNew(ServletFileUpload.class, (Object[])new Object[]{fileItemFactory}).andReturn((Object)upload);
        EasyMock.expect((Object)ServletFileUpload.isMultipartContent((HttpServletRequest)this.servletRequest)).andReturn((Object)true);
        ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
        FileItem item1 = (FileItem)PowerMock.createMock(FileItem.class);
        fileItems.add(item1);
        FileItem item2 = (FileItem)PowerMock.createMock(FileItem.class);
        fileItems.add(item2);
        EasyMock.expect((Object)upload.parseRequest(this.servletRequest)).andReturn(fileItems);
        EasyMock.expect((Object)item1.getFieldName()).andReturn((Object)"form");
        EasyMock.expect((Object)item2.getFieldName()).andReturn((Object)"form");
        EasyMock.expect((Object)this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.servletRequest, this.servletResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testNoMultipartRequest() throws Exception {
        EasyMock.expect((Object)this.servletRequest.getQueryString()).andReturn((Object)"");
        EasyMock.expect((Object)this.servletRequest.getParameter("id")).andReturn((Object)"00:02:D1:09:D9:37");
        LanDeviceEntity device = new LanDeviceEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:09:D9:37")).andReturn((Object)device);
        EasyMock.expect((Object)ServletFileUpload.isMultipartContent((HttpServletRequest)this.servletRequest)).andReturn((Object)false);
        EasyMock.expect((Object)this.eventService.processEvent(Integer.valueOf(1), "MOTION", null, "VIDEO", null, null, null)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.servletRequest, this.servletResponse);
        PowerMock.verifyAll();
    }
}

