/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.db.dao.ProductDAO;
import pl.smartapps.restserver.db.dao.SSOParameterDAO;
import pl.smartapps.restserver.db.dao.SSOServiceDAO;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.servlet.SsoAuthenticationServlet;
import pl.smartapps.restserver.sso.SsoProvider;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={SsoAuthenticationServlet.class, SsoProvider.class, Date.class})
public class SsoAuthenticationServletTests {
    private SsoAuthenticationServlet ssoAuthenticationServlet;
    private ParameterService parameterService;
    private LanDeviceService lanDeviceService;
    private ProductDAO productDAO;
    private UserDAO userDAO;
    private SSOServiceDAO ssoServiceDAO;
    private SSOParameterDAO ssoParameterDAO;
    private AuthenticationUtils authUtils;
    private HttpServletRequest request;
    private HttpServletResponse response;

    @Before
    public void setUp() {
        this.ssoAuthenticationServlet = new SsoAuthenticationServlet();
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.ssoAuthenticationServlet.setParameterService(this.parameterService);
        this.lanDeviceService = (LanDeviceService)PowerMock.createMock(LanDeviceService.class);
        this.ssoAuthenticationServlet.setLanDeviceService(this.lanDeviceService);
        this.productDAO = (ProductDAO)PowerMock.createMock(ProductDAO.class);
        this.ssoAuthenticationServlet.setProductDAO(this.productDAO);
        this.userDAO = (UserDAO)PowerMock.createMock(UserDAO.class);
        this.ssoAuthenticationServlet.setUserDAO(this.userDAO);
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.ssoAuthenticationServlet.setAuthenticationUtils(this.authUtils);
        this.request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        this.response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
    }

    @Test
    public void testHandleRequestEmptyToken() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getRequestURL()).andReturn(null);
        EasyMock.expect((Object)this.request.getParameter("check_token")).andReturn(null);
        this.response.setStatus(404);
        PowerMock.replayAll((Object[])new Object[0]);
        this.ssoAuthenticationServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testHandleRequestEmptyProvider() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getRequestURL()).andReturn(null);
        String token = "token";
        EasyMock.expect((Object)this.request.getParameter("check_token")).andReturn((Object)token);
        EasyMock.expect((Object)this.request.getParameter("provider")).andReturn(null);
        ArrayList names = new ArrayList();
        EasyMock.expect((Object)this.ssoServiceDAO.getAllSSONames()).andReturn(names);
        this.response.setStatus(404);
        PowerMock.replayAll((Object[])new Object[0]);
        this.ssoAuthenticationServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testHandleRequestWrongProvider() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getRequestURL()).andReturn(null);
        String token = "token";
        EasyMock.expect((Object)this.request.getParameter("check_token")).andReturn((Object)token);
        String provider = "facebook";
        EasyMock.expect((Object)this.request.getParameter("provider")).andReturn((Object)provider);
        ArrayList<String> names = new ArrayList<String>();
        names.add("google");
        names.add("epicentro");
        EasyMock.expect((Object)this.ssoServiceDAO.getAllSSONames()).andReturn(names);
        this.response.setStatus(404);
        PowerMock.replayAll((Object[])new Object[0]);
        this.ssoAuthenticationServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testHandleRequestUserInfoError() throws Exception {
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testHandleRequestUserInfoNewUser() throws Exception {
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testHandleRequestUserUserWithEmailExists() throws Exception {
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testHandleRequestUserInfoNewUserRegisterNAS() throws Exception {
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testHandleRequestUserInfoNewUserAuthFailed() throws Exception {
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testHandleRequestUserInfoExistingUser() throws Exception {
        Assert.assertTrue((boolean)false);
    }
}

