/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.servlet;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.PaymentService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.servlet.PostFinancePaymentServlet;
import pl.smartapps.restserver.servlet.ServletUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={PostFinancePaymentServlet.class, MessageDigest.class, ServletUtils.class})
public class PostFinancePaymentServletTests {
    private PostFinancePaymentServlet paymentServlet;
    private PaymentService paymentService;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ParameterService parameterService;

    @Before
    public void setUp() {
        this.paymentServlet = new PostFinancePaymentServlet();
        this.paymentService = (PaymentService)PowerMock.createMock(PaymentService.class);
        this.paymentServlet.setPaymentService(this.paymentService);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.paymentServlet.setParameterService(this.parameterService);
        this.request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        this.response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
    }

    @Test
    public void testProcessCorrectPaymentRequest() throws ServletException, IOException, NoSuchAlgorithmException, InvalidSessionException {
        String trustedIpAddressed = "213.254.248.114, 213.254.248.98, 212.23.45.97, 212.35.124.164";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.POSTFINANCE_TRUSTED_IP_ADDRESSES)).andReturn((Object)trustedIpAddressed);
        EasyMock.expect((Object)this.request.getRemoteAddr()).andReturn((Object)"212.23.45.97");
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.POSTFINANCE_SHA_OUT_PASSPHRASE)).andReturn((Object)"??test??");
        EasyMock.expect((Object)this.request.getParameterMap()).andReturn((Object)this.preparePaymentParams("9")).times(15);
        MessageDigest sha1 = (MessageDigest)PowerMock.createMock(MessageDigest.class);
        PowerMock.mockStatic(MessageDigest.class);
        EasyMock.expect((Object)MessageDigest.getInstance("SHA1")).andReturn((Object)sha1);
        EasyMock.expect((Object)sha1.digest(EasyMock.aryEq((byte[])this.constructRawMessage("9")))).andReturn((Object)PostFinancePaymentServletTests.hexStringToByteArray((String)"70BB81F22CAE4CB65758C1F660401A5904254FA9"));
        PowerMock.mockStatic(ServletUtils.class);
        EasyMock.expect((Object)ServletUtils.toString((HttpServletRequest)this.request, (String)", ")).andReturn((Object)"raw_response");
        this.paymentService.processPaymentNotification("20111013123456000014", "success", "11831050", null, "raw_response");
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessPaymentRequestFromUntrustedIpAddress() throws ServletException, IOException, NoSuchAlgorithmException {
        String trustedIpAddressed = "213.254.248.114, 213.254.248.98, 212.23.45.97, 212.35.124.164";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.POSTFINANCE_TRUSTED_IP_ADDRESSES)).andReturn((Object)trustedIpAddressed);
        EasyMock.expect((Object)this.request.getRemoteAddr()).andReturn((Object)"127.0.0.1");
        PowerMock.mockStatic(ServletUtils.class);
        EasyMock.expect((Object)ServletUtils.toString((HttpServletRequest)this.request, (String)", ")).andReturn((Object)"raw_response");
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessTamperedPaymentRequest() throws ServletException, IOException, NoSuchAlgorithmException {
        String trustedIpAddressed = "213.254.248.114, 213.254.248.98, 212.23.45.97, 212.35.124.164";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.POSTFINANCE_TRUSTED_IP_ADDRESSES)).andReturn((Object)trustedIpAddressed);
        EasyMock.expect((Object)this.request.getRemoteAddr()).andReturn((Object)"212.23.45.97");
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.POSTFINANCE_SHA_OUT_PASSPHRASE)).andReturn((Object)"??test??");
        EasyMock.expect((Object)this.request.getParameterMap()).andReturn((Object)this.preparePaymentParams("9")).times(15);
        MessageDigest sha1 = (MessageDigest)PowerMock.createMock(MessageDigest.class);
        PowerMock.mockStatic(MessageDigest.class);
        EasyMock.expect((Object)MessageDigest.getInstance("SHA1")).andReturn((Object)sha1);
        EasyMock.expect((Object)sha1.digest(EasyMock.aryEq((byte[])this.constructRawMessage("9")))).andReturn((Object)PostFinancePaymentServletTests.hexStringToByteArray((String)"70BB81F22CAE4CB65758C1F660401A5904254FA0"));
        PowerMock.mockStatic(ServletUtils.class);
        EasyMock.expect((Object)ServletUtils.toString((HttpServletRequest)this.request, (String)", ")).andReturn((Object)"raw_response");
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessIncorrectPaymentRequest() throws ServletException, IOException, NoSuchAlgorithmException, InvalidSessionException {
        String trustedIpAddressed = "213.254.248.114, 213.254.248.98, 212.23.45.97, 212.35.124.164";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.POSTFINANCE_TRUSTED_IP_ADDRESSES)).andReturn((Object)trustedIpAddressed);
        EasyMock.expect((Object)this.request.getRemoteAddr()).andReturn((Object)"212.23.45.97");
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.POSTFINANCE_SHA_OUT_PASSPHRASE)).andReturn((Object)"??test??");
        EasyMock.expect((Object)this.request.getParameterMap()).andReturn((Object)this.preparePaymentParams("1")).times(15);
        MessageDigest sha1 = (MessageDigest)PowerMock.createMock(MessageDigest.class);
        PowerMock.mockStatic(MessageDigest.class);
        EasyMock.expect((Object)MessageDigest.getInstance("SHA1")).andReturn((Object)sha1);
        EasyMock.expect((Object)sha1.digest(EasyMock.aryEq((byte[])this.constructRawMessage("1")))).andReturn((Object)PostFinancePaymentServletTests.hexStringToByteArray((String)"70BB81F22CAE4CB65758C1F660401A5904254FA9"));
        PowerMock.mockStatic(ServletUtils.class);
        EasyMock.expect((Object)ServletUtils.toString((HttpServletRequest)this.request, (String)", ")).andReturn((Object)"raw_response");
        this.paymentService.processPaymentNotification("20111013123456000014", "1", "11831050", null, "raw_response");
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    private Map<String, String[]> preparePaymentParams(String status) {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("amount", new String[]{"82.8"});
        params.put("PM", new String[]{"PostFinance e-finance"});
        params.put("orderID", new String[]{"20111013123456000014"});
        params.put("ACCEPTANCE", new String[]{"TEST"});
        params.put("PAYID", new String[]{"11831050"});
        params.put("TRXDATE", new String[]{"09/28/11"});
        params.put("SHASIGN", new String[]{"70BB81F22CAE4CB65758C1F660401A5904254FA9"});
        params.put("BRAND", new String[]{"PostFinance e-finance"});
        params.put("STATUS", new String[]{status});
        params.put("NCERROR", new String[]{"0"});
        params.put("currency", new String[]{"CHF"});
        params.put("currency", new String[]{"CHF"});
        params.put("CVCCheck", new String[]{"NO"});
        return params;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    private byte[] constructRawMessage(String status) {
        StringBuilder rawMessage = new StringBuilder();
        rawMessage.append("ACCEPTANCE=TEST??test??");
        rawMessage.append("AMOUNT=82.8??test??");
        rawMessage.append("BRAND=PostFinance e-finance??test??");
        rawMessage.append("CURRENCY=CHF??test??");
        rawMessage.append("CVCCHECK=NO??test??");
        rawMessage.append("NCERROR=0??test??");
        rawMessage.append("ORDERID=20111013123456000014??test??");
        rawMessage.append("PAYID=11831050??test??");
        rawMessage.append("PM=PostFinance e-finance??test??");
        rawMessage.append("STATUS=").append(status).append("??test??");
        rawMessage.append("TRXDATE=09/28/11??test??");
        System.out.println("test raw message: " + rawMessage.toString());
        return rawMessage.toString().getBytes();
    }
}

