/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.servlet.GetBrowserLanguageServlet;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={GetBrowserLanguageServlet.class, DefaultHttpClient.class, IOUtils.class})
public class GetBrowserLanguageServletTests {
    private GetBrowserLanguageServlet servlet;
    private HttpServletRequest request;
    private HttpServletResponse response;

    @Before
    public void setUp() {
        this.servlet = new GetBrowserLanguageServlet();
        this.request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        this.response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
    }

    @After
    public void tearDown() {
        this.servlet = null;
        PowerMock.resetAll((Object[])new Object[0]);
    }

    @Test
    public void testLanguageInBrowserRequest() throws ServletException, IOException {
        String acceptLanguageHeader = "en";
        EasyMock.expect((Object)this.request.getHeader("Accept-Language")).andReturn((Object)acceptLanguageHeader);
        this.response.setContentType("text/plain");
        EasyMock.expect((Object)this.request.getHeader("X-Forwarded-For")).andReturn(null);
        EasyMock.expect((Object)this.request.getRemoteAddr()).andReturn((Object)"127.0.0.1");
        String expectedLang = "en-en";
        ServletOutputStream outputStream = (ServletOutputStream)PowerMock.createMock(ServletOutputStream.class);
        EasyMock.expect((Object)this.response.getOutputStream()).andReturn((Object)outputStream);
        outputStream.write(EasyMock.aryEq((byte[])expectedLang.getBytes()));
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testLanguageAndCountryInBrowserRequest() throws ServletException, IOException {
        String acceptLanguageHeader = "en-us";
        EasyMock.expect((Object)this.request.getHeader("Accept-Language")).andReturn((Object)acceptLanguageHeader);
        this.response.setContentType("text/plain");
        EasyMock.expect((Object)this.request.getHeader("X-Forwarded-For")).andReturn(null);
        EasyMock.expect((Object)this.request.getRemoteAddr()).andReturn((Object)"127.0.0.1");
        String expectedLang = "en-us";
        ServletOutputStream outputStream = (ServletOutputStream)PowerMock.createMock(ServletOutputStream.class);
        EasyMock.expect((Object)this.response.getOutputStream()).andReturn((Object)outputStream);
        outputStream.write(EasyMock.aryEq((byte[])expectedLang.getBytes()));
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoteAddressInForwardedForHeader() throws Exception {
        String acceptLanguageHeader = "en";
        EasyMock.expect((Object)this.request.getHeader("Accept-Language")).andReturn((Object)acceptLanguageHeader);
        this.response.setContentType("text/plain");
        String remoteIp = "91.200.187.34";
        EasyMock.expect((Object)this.request.getHeader("X-Forwarded-For")).andReturn((Object)remoteIp);
        String serviceResponse = "Aachen;Nordrhein-westfalen;Germany;Deutsche Telekom Ag;50.7708;6.1053;DE";
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams params = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)params).times(2);
        EasyMock.expect((Object)params.setParameter("http.socket.timeout", (Object)3000)).andReturn((Object)params);
        EasyMock.expect((Object)params.setParameter("http.connection.timeout", (Object)3000)).andReturn((Object)params);
        HttpGet httpGet = (HttpGet)PowerMock.createMock(HttpGet.class);
        PowerMock.expectNew(HttpGet.class, (Object[])new Object[]{"http://api.geoio.com/q.php?key=qKSqK4TqKI54ZKAB&qt=geoip&d=semi&q=" + remoteIp}).andReturn((Object)httpGet);
        HttpResponse httpResponse = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpGet)).andReturn((Object)httpResponse);
        StatusLine statusLine = (StatusLine)PowerMock.createMock(StatusLine.class);
        EasyMock.expect((Object)httpResponse.getStatusLine()).andReturn((Object)statusLine);
        EasyMock.expect((Object)statusLine.getStatusCode()).andReturn((Object)200);
        HttpEntity httpEntity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)httpResponse.getEntity()).andReturn((Object)httpEntity);
        InputStream httpContent = (InputStream)PowerMock.createMock(InputStream.class);
        EasyMock.expect((Object)httpEntity.getContent()).andReturn((Object)httpContent);
        PowerMock.mockStatic(IOUtils.class);
        EasyMock.expect((Object)IOUtils.toString((InputStream)httpContent, (String)"UTF-8")).andReturn((Object)serviceResponse);
        String expectedLang = "en-DE";
        ServletOutputStream outputStream = (ServletOutputStream)PowerMock.createMock(ServletOutputStream.class);
        EasyMock.expect((Object)this.response.getOutputStream()).andReturn((Object)outputStream);
        outputStream.write(EasyMock.aryEq((byte[])expectedLang.getBytes()));
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testPrivateAddressInForwardedForHeader() throws Exception {
        String acceptLanguageHeader = "en";
        EasyMock.expect((Object)this.request.getHeader("Accept-Language")).andReturn((Object)acceptLanguageHeader);
        this.response.setContentType("text/plain");
        String remoteIp = "192.168.21.119";
        EasyMock.expect((Object)this.request.getHeader("X-Forwarded-For")).andReturn((Object)remoteIp);
        String expectedLang = "en-en";
        ServletOutputStream outputStream = (ServletOutputStream)PowerMock.createMock(ServletOutputStream.class);
        EasyMock.expect((Object)this.response.getOutputStream()).andReturn((Object)outputStream);
        outputStream.write(EasyMock.aryEq((byte[])expectedLang.getBytes()));
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoteAddressInForwardedForHeaderMultipleProxies() throws Exception {
        String acceptLanguageHeader = "en";
        EasyMock.expect((Object)this.request.getHeader("Accept-Language")).andReturn((Object)acceptLanguageHeader);
        this.response.setContentType("text/plain");
        String remoteIp = "91.200.187.34";
        EasyMock.expect((Object)this.request.getHeader("X-Forwarded-For")).andReturn((Object)(String.valueOf(remoteIp) + ", 81.81.81.81, 92.92.92.92"));
        String serviceResponse = "Aachen;Nordrhein-westfalen;Germany;Deutsche Telekom Ag;50.7708;6.1053;DE";
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams params = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)params).times(2);
        EasyMock.expect((Object)params.setParameter("http.socket.timeout", (Object)3000)).andReturn((Object)params);
        EasyMock.expect((Object)params.setParameter("http.connection.timeout", (Object)3000)).andReturn((Object)params);
        HttpGet httpGet = (HttpGet)PowerMock.createMock(HttpGet.class);
        PowerMock.expectNew(HttpGet.class, (Object[])new Object[]{"http://api.geoio.com/q.php?key=qKSqK4TqKI54ZKAB&qt=geoip&d=semi&q=" + remoteIp}).andReturn((Object)httpGet);
        HttpResponse httpResponse = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpGet)).andReturn((Object)httpResponse);
        StatusLine statusLine = (StatusLine)PowerMock.createMock(StatusLine.class);
        EasyMock.expect((Object)httpResponse.getStatusLine()).andReturn((Object)statusLine);
        EasyMock.expect((Object)statusLine.getStatusCode()).andReturn((Object)200);
        HttpEntity httpEntity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)httpResponse.getEntity()).andReturn((Object)httpEntity);
        InputStream httpContent = (InputStream)PowerMock.createMock(InputStream.class);
        EasyMock.expect((Object)httpEntity.getContent()).andReturn((Object)httpContent);
        PowerMock.mockStatic(IOUtils.class);
        EasyMock.expect((Object)IOUtils.toString((InputStream)httpContent, (String)"UTF-8")).andReturn((Object)serviceResponse);
        String expectedLang = "en-DE";
        ServletOutputStream outputStream = (ServletOutputStream)PowerMock.createMock(ServletOutputStream.class);
        EasyMock.expect((Object)this.response.getOutputStream()).andReturn((Object)outputStream);
        outputStream.write(EasyMock.aryEq((byte[])expectedLang.getBytes()));
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testLoopbackAddressAsRemoteAddress() throws Exception {
        String acceptLanguageHeader = "en";
        EasyMock.expect((Object)this.request.getHeader("Accept-Language")).andReturn((Object)acceptLanguageHeader);
        this.response.setContentType("text/plain");
        EasyMock.expect((Object)this.request.getHeader("X-Forwarded-For")).andReturn(null);
        EasyMock.expect((Object)this.request.getRemoteAddr()).andReturn((Object)"127.0.0.1");
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andStubThrow((Throwable)new RuntimeException("It should not be called"));
        String expectedLang = "en-en";
        ServletOutputStream outputStream = (ServletOutputStream)PowerMock.createMock(ServletOutputStream.class);
        EasyMock.expect((Object)this.response.getOutputStream()).andReturn((Object)outputStream);
        outputStream.write(EasyMock.aryEq((byte[])expectedLang.getBytes()));
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCClassPrivateAddressAsRemoteAddress() throws Exception {
        String acceptLanguageHeader = "en";
        EasyMock.expect((Object)this.request.getHeader("Accept-Language")).andReturn((Object)acceptLanguageHeader);
        this.response.setContentType("text/plain");
        EasyMock.expect((Object)this.request.getHeader("X-Forwarded-For")).andReturn(null);
        EasyMock.expect((Object)this.request.getRemoteAddr()).andReturn((Object)"192.168.21.129");
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andStubThrow((Throwable)new RuntimeException("It should not be called"));
        String expectedLang = "en-en";
        ServletOutputStream outputStream = (ServletOutputStream)PowerMock.createMock(ServletOutputStream.class);
        EasyMock.expect((Object)this.response.getOutputStream()).andReturn((Object)outputStream);
        outputStream.write(EasyMock.aryEq((byte[])expectedLang.getBytes()));
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testBClassPrivateAddressAsRemoteAddress() throws Exception {
        String acceptLanguageHeader = "en";
        EasyMock.expect((Object)this.request.getHeader("Accept-Language")).andReturn((Object)acceptLanguageHeader);
        this.response.setContentType("text/plain");
        EasyMock.expect((Object)this.request.getHeader("X-Forwarded-For")).andReturn(null);
        EasyMock.expect((Object)this.request.getRemoteAddr()).andReturn((Object)"172.21.10.129");
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andStubThrow((Throwable)new RuntimeException("It should not be called"));
        String expectedLang = "en-en";
        ServletOutputStream outputStream = (ServletOutputStream)PowerMock.createMock(ServletOutputStream.class);
        EasyMock.expect((Object)this.response.getOutputStream()).andReturn((Object)outputStream);
        outputStream.write(EasyMock.aryEq((byte[])expectedLang.getBytes()));
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testAClassPrivateAddressAsRemoteAddress() throws Exception {
        String acceptLanguageHeader = "en";
        EasyMock.expect((Object)this.request.getHeader("Accept-Language")).andReturn((Object)acceptLanguageHeader);
        this.response.setContentType("text/plain");
        EasyMock.expect((Object)this.request.getHeader("X-Forwarded-For")).andReturn(null);
        EasyMock.expect((Object)this.request.getRemoteAddr()).andReturn((Object)"10.10.21.129");
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andStubThrow((Throwable)new RuntimeException("It should not be called"));
        String expectedLang = "en-en";
        ServletOutputStream outputStream = (ServletOutputStream)PowerMock.createMock(ServletOutputStream.class);
        EasyMock.expect((Object)this.response.getOutputStream()).andReturn((Object)outputStream);
        outputStream.write(EasyMock.aryEq((byte[])expectedLang.getBytes()));
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testLinkLocalAddressAsRemoteAddress() throws Exception {
        String acceptLanguageHeader = "en";
        EasyMock.expect((Object)this.request.getHeader("Accept-Language")).andReturn((Object)acceptLanguageHeader);
        this.response.setContentType("text/plain");
        EasyMock.expect((Object)this.request.getHeader("X-Forwarded-For")).andReturn(null);
        EasyMock.expect((Object)this.request.getRemoteAddr()).andReturn((Object)"169.254.1.1");
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andStubThrow((Throwable)new RuntimeException("It should not be called"));
        String expectedLang = "en-en";
        ServletOutputStream outputStream = (ServletOutputStream)PowerMock.createMock(ServletOutputStream.class);
        EasyMock.expect((Object)this.response.getOutputStream()).andReturn((Object)outputStream);
        outputStream.write(EasyMock.aryEq((byte[])expectedLang.getBytes()));
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testPublicAddressAsRemoteAddress() throws Exception {
        String acceptLanguageHeader = "en";
        EasyMock.expect((Object)this.request.getHeader("Accept-Language")).andReturn((Object)acceptLanguageHeader);
        this.response.setContentType("text/plain");
        String remoteIp = "91.200.187.34";
        EasyMock.expect((Object)this.request.getHeader("X-Forwarded-For")).andReturn(null);
        EasyMock.expect((Object)this.request.getRemoteAddr()).andReturn((Object)remoteIp);
        String serviceResponse = "Aachen;Nordrhein-westfalen;Germany;Deutsche Telekom Ag;50.7708;6.1053;DE";
        DefaultHttpClient httpClient = (DefaultHttpClient)PowerMock.createMock(DefaultHttpClient.class);
        PowerMock.expectNew(DefaultHttpClient.class, (Object[])new Object[0]).andReturn((Object)httpClient);
        HttpParams params = (HttpParams)PowerMock.createMock(HttpParams.class);
        EasyMock.expect((Object)httpClient.getParams()).andReturn((Object)params).times(2);
        EasyMock.expect((Object)params.setParameter("http.socket.timeout", (Object)3000)).andReturn((Object)params);
        EasyMock.expect((Object)params.setParameter("http.connection.timeout", (Object)3000)).andReturn((Object)params);
        HttpGet httpGet = (HttpGet)PowerMock.createMock(HttpGet.class);
        PowerMock.expectNew(HttpGet.class, (Object[])new Object[]{"http://api.geoio.com/q.php?key=qKSqK4TqKI54ZKAB&qt=geoip&d=semi&q=" + remoteIp}).andReturn((Object)httpGet);
        HttpResponse httpResponse = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpGet)).andReturn((Object)httpResponse);
        StatusLine statusLine = (StatusLine)PowerMock.createMock(StatusLine.class);
        EasyMock.expect((Object)httpResponse.getStatusLine()).andReturn((Object)statusLine);
        EasyMock.expect((Object)statusLine.getStatusCode()).andReturn((Object)200);
        HttpEntity httpEntity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)httpResponse.getEntity()).andReturn((Object)httpEntity);
        InputStream httpContent = (InputStream)PowerMock.createMock(InputStream.class);
        EasyMock.expect((Object)httpEntity.getContent()).andReturn((Object)httpContent);
        PowerMock.mockStatic(IOUtils.class);
        EasyMock.expect((Object)IOUtils.toString((InputStream)httpContent, (String)"UTF-8")).andReturn((Object)serviceResponse);
        String expectedLang = "en-DE";
        ServletOutputStream outputStream = (ServletOutputStream)PowerMock.createMock(ServletOutputStream.class);
        EasyMock.expect((Object)this.response.getOutputStream()).andReturn((Object)outputStream);
        outputStream.write(EasyMock.aryEq((byte[])expectedLang.getBytes()));
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }
}

