/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.db.dao.EventDAO;
import pl.smartapps.restserver.db.main.EventEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.service.EventsFilesController;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.AwsS3Controller;
import pl.smartapps.restserver.servlet.EventImageServlet;
import pl.smartapps.restserver.test.rest.TestDataUtils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={EventImageServlet.class})
public class EventImageServletTests {
    private EventImageServlet eventImageServlet;
    private EventDAO eventDAO;
    private AuthenticationUtils authUtils;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private EventsFilesController eventsFilesController;
    private LanDeviceService lanDeviceService;

    @Before
    public void setUp() {
        this.eventImageServlet = new EventImageServlet();
        this.eventDAO = (EventDAO)PowerMock.createMock(EventDAO.class);
        this.eventImageServlet.setEventDAO(this.eventDAO);
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.eventImageServlet.setAuthUtils(this.authUtils);
        this.request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        this.response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        this.eventsFilesController = (EventsFilesController)PowerMock.createMock(AwsS3Controller.class);
        this.eventImageServlet.setEventsFilesController(this.eventsFilesController);
        this.lanDeviceService = (LanDeviceService)PowerMock.createMock(LanDeviceService.class);
        this.eventImageServlet.setLanDeviceService(this.lanDeviceService);
    }

    @Test
    public void testCallByNotLoggedUser() throws ServletException, IOException {
        EasyMock.expect((Object)this.authUtils.isLoggedIn()).andReturn((Object)false);
        this.response.setStatus(401);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventImageServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testEventIdLack() throws ServletException, IOException {
        EasyMock.expect((Object)this.authUtils.isLoggedIn()).andReturn((Object)true);
        EasyMock.expect((Object)this.request.getParameter("eventId")).andReturn(null);
        this.response.setStatus(404);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventImageServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testNotFoundEvent() throws ServletException, IOException {
        EasyMock.expect((Object)this.authUtils.isLoggedIn()).andReturn((Object)true);
        EasyMock.expect((Object)this.request.getParameter("eventId")).andReturn((Object)"1");
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn(null);
        this.response.setStatus(404);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventImageServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSuccessfulCall() throws ServletException, IOException, InvalidSessionException {
        EasyMock.expect((Object)this.authUtils.isLoggedIn()).andReturn((Object)true);
        EasyMock.expect((Object)this.request.getParameter("eventId")).andReturn((Object)"1");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EventEntity event = TestDataUtils.prepareEventEntity();
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        LanDeviceEntity dev = new LanDeviceEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)dev);
        this.eventsFilesController.downloadImage(this.request, this.response, event, "20110411143000_1.jpg", "hm_TC5633-TCSW-0100h_20110411143000.jpg");
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventImageServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSuccessfulCallUTF8Name() throws ServletException, IOException, InvalidSessionException {
        EasyMock.expect((Object)this.authUtils.isLoggedIn()).andReturn((Object)true);
        EasyMock.expect((Object)this.request.getParameter("eventId")).andReturn((Object)"1");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EventEntity event = TestDataUtils.prepareEventEntity();
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        LanDeviceEntity dev = new LanDeviceEntity(Integer.valueOf(1));
        event.getLanDevice().setName("Camera \u0141\u00f3\u017cko");
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)dev);
        this.eventsFilesController.downloadImage(this.request, this.response, event, "20110411143000_1.jpg", "hm_Camera \u0141\u00f3\u017cko_20110411143000.jpg");
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventImageServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSuccessfulCallUserWithNoAccess() throws ServletException, IOException, InvalidSessionException {
        EasyMock.expect((Object)this.authUtils.isLoggedIn()).andReturn((Object)true);
        EasyMock.expect((Object)this.request.getParameter("eventId")).andReturn((Object)"1");
        EventEntity event = TestDataUtils.prepareEventEntity();
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn(null);
        this.response.setStatus(404);
        PowerMock.replayAll((Object[])new Object[0]);
        this.eventImageServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @After
    public void tearDown() {
        this.eventImageServlet = null;
        this.eventDAO = null;
        this.authUtils = null;
    }
}

