/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.servlet;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.codehaus.jackson.map.ObjectMapper;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.db.dao.DebuglogDAO;
import pl.smartapps.restserver.db.main.DebuglogEntity;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.Debuglog;
import pl.smartapps.restserver.service.impl.JsonDebuglogMapper;
import pl.smartapps.restserver.servlet.DebuglogServlet;
import pl.smartapps.restserver.servlet.PostFinancePaymentServlet;
import pl.smartapps.restserver.servlet.ServletUtils;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={PostFinancePaymentServlet.class, ObjectMapper.class, ServletUtils.class})
public class DebuglogServletTests {
    private DebuglogServlet debuglogServlet;
    private JsonDebuglogMapper jsonDebuglogMapper;
    private DebuglogDAO debuglogDAO;
    private AuthenticationUtils authUtils;
    private HttpServletRequest request;
    private HttpServletResponse response;

    @Before
    public void testUp() {
        this.debuglogServlet = new DebuglogServlet();
        this.jsonDebuglogMapper = (JsonDebuglogMapper)PowerMock.createMock(JsonDebuglogMapper.class);
        this.debuglogServlet.setMapper(this.jsonDebuglogMapper);
        this.debuglogDAO = (DebuglogDAO)PowerMock.createMock(DebuglogDAO.class);
        this.debuglogServlet.setDebuglogDAO(this.debuglogDAO);
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.debuglogServlet.setAuthUtils(this.authUtils);
        this.request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        this.response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
    }

    @Test
    public void testHandleRequestSuccessfuly() throws Exception {
        ServletInputStream stream = (ServletInputStream)PowerMock.createMock(ServletInputStream.class);
        EasyMock.expect((Object)this.request.getInputStream()).andReturn((Object)stream);
        ArrayList<Debuglog> debuglogs = new ArrayList<Debuglog>();
        debuglogs.add(TestDataUtils.createDebuglog((String)"file1", (Integer)1, (String)"loggerName1", (Integer)0, (String)"message1", (String)"ndc1", (String)"thread1", (Integer)1319024245, (Integer)192576));
        debuglogs.add(TestDataUtils.createDebuglog((String)"file2", (Integer)2, (String)"loggerName2", (Integer)10000, (String)"message2", (String)"ndc2", (String)"thread2", (Integer)1319024245, (Integer)192576));
        debuglogs.add(TestDataUtils.createDebuglog((String)"file3", (Integer)3, (String)"loggerName3", (Integer)20000, (String)"message3", (String)"ndc3", (String)"thread3", (Integer)1319024245, (Integer)192576));
        debuglogs.add(TestDataUtils.createDebuglog((String)"file4", (Integer)4, (String)"loggerName4", (Integer)30000, (String)"message4", (String)"ndc4", (String)"thread4", (Integer)1319024245, (Integer)192576));
        debuglogs.add(TestDataUtils.createDebuglog((String)"file5", (Integer)5, (String)"loggerName5", (Integer)40000, (String)"message5", (String)"ndc5", (String)"thread5", (Integer)1319024245, (Integer)192576));
        debuglogs.add(TestDataUtils.createDebuglog((String)"file6", (Integer)6, (String)"loggerName6", (Integer)50000, (String)"message6", (String)"ndc6", (String)"thread6", (Integer)1319024245, (Integer)192576));
        debuglogs.add(TestDataUtils.createDebuglog((String)"file7", (Integer)7, (String)"loggerName7", (Integer)60000, (String)"message7", (String)"ndc7", (String)"thread7", (Integer)1319024245, (Integer)192576));
        EasyMock.expect((Object)this.jsonDebuglogMapper.map((InputStream)stream)).andReturn(debuglogs);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject).times(7);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session).times(7);
        EasyMock.expect((Object)session.getId()).andReturn((Object)"123").times(7);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)TestDataUtils.prepareUserEntity()).times(7);
        Date timestamp = Utils.constructDate((int)2011, (int)10, (int)19, (int)13, (int)37, (int)25);
        DebuglogEntity entity1 = TestDataUtils.createDebuglogEntity((String)"file1", (Integer)1, (String)"loggerName1", (String)"TRACE", (String)"message1", (String)"ndc1", (String)"thread1", (Date)timestamp, (String)"123", (String)"test", null);
        Capture captureEntity1 = new Capture();
        EasyMock.expect((Object)this.debuglogDAO.createDebuglog((DebuglogEntity)EasyMock.capture((Capture)captureEntity1))).andReturn((Object)entity1);
        DebuglogEntity entity2 = TestDataUtils.createDebuglogEntity((String)"file2", (Integer)2, (String)"loggerName2", (String)"DEBUG", (String)"message2", (String)"ndc2", (String)"thread2", (Date)timestamp, (String)"123", (String)"test", null);
        Capture captureEntity2 = new Capture();
        EasyMock.expect((Object)this.debuglogDAO.createDebuglog((DebuglogEntity)EasyMock.capture((Capture)captureEntity2))).andReturn((Object)entity2);
        DebuglogEntity entity3 = TestDataUtils.createDebuglogEntity((String)"file3", (Integer)3, (String)"loggerName3", (String)"INFO", (String)"message3", (String)"ndc3", (String)"thread3", (Date)timestamp, (String)"123", (String)"test", null);
        Capture captureEntity3 = new Capture();
        EasyMock.expect((Object)this.debuglogDAO.createDebuglog((DebuglogEntity)EasyMock.capture((Capture)captureEntity3))).andReturn((Object)entity3);
        DebuglogEntity entity4 = TestDataUtils.createDebuglogEntity((String)"file4", (Integer)4, (String)"loggerName4", (String)"WARN", (String)"message4", (String)"ndc4", (String)"thread4", (Date)timestamp, (String)"123", (String)"test", null);
        Capture captureEntity4 = new Capture();
        EasyMock.expect((Object)this.debuglogDAO.createDebuglog((DebuglogEntity)EasyMock.capture((Capture)captureEntity4))).andReturn((Object)entity4);
        DebuglogEntity entity5 = TestDataUtils.createDebuglogEntity((String)"file5", (Integer)5, (String)"loggerName5", (String)"ERROR", (String)"message5", (String)"ndc5", (String)"thread5", (Date)timestamp, (String)"123", (String)"test", null);
        Capture captureEntity5 = new Capture();
        EasyMock.expect((Object)this.debuglogDAO.createDebuglog((DebuglogEntity)EasyMock.capture((Capture)captureEntity5))).andReturn((Object)entity5);
        DebuglogEntity entity6 = TestDataUtils.createDebuglogEntity((String)"file6", (Integer)6, (String)"loggerName6", (String)"FATAL", (String)"message6", (String)"ndc6", (String)"thread6", (Date)timestamp, (String)"123", (String)"test", null);
        Capture captureEntity6 = new Capture();
        EasyMock.expect((Object)this.debuglogDAO.createDebuglog((DebuglogEntity)EasyMock.capture((Capture)captureEntity6))).andReturn((Object)entity6);
        DebuglogEntity entity7 = TestDataUtils.createDebuglogEntity((String)"file7", (Integer)7, (String)"loggerName7", (String)"OFF", (String)"message7", (String)"ndc7", (String)"thread7", (Date)timestamp, (String)"123", (String)"test", null);
        Capture captureEntity7 = new Capture();
        EasyMock.expect((Object)this.debuglogDAO.createDebuglog((DebuglogEntity)EasyMock.capture((Capture)captureEntity7))).andReturn((Object)entity7);
        PowerMock.replayAll((Object[])new Object[0]);
        this.debuglogServlet.handleRequest(this.request, this.response);
        Assert.assertTrue((boolean)Utils.verifyDebullogEnity((Capture)captureEntity1, (DebuglogEntity)entity1));
        Assert.assertTrue((boolean)Utils.verifyDebullogEnity((Capture)captureEntity2, (DebuglogEntity)entity2));
        Assert.assertTrue((boolean)Utils.verifyDebullogEnity((Capture)captureEntity3, (DebuglogEntity)entity3));
        Assert.assertTrue((boolean)Utils.verifyDebullogEnity((Capture)captureEntity4, (DebuglogEntity)entity4));
        Assert.assertTrue((boolean)Utils.verifyDebullogEnity((Capture)captureEntity5, (DebuglogEntity)entity5));
        Assert.assertTrue((boolean)Utils.verifyDebullogEnity((Capture)captureEntity6, (DebuglogEntity)entity6));
        Assert.assertTrue((boolean)Utils.verifyDebullogEnity((Capture)captureEntity7, (DebuglogEntity)entity7));
        PowerMock.verifyAll();
    }

    @Test
    public void testHandleRequestLogsNull() throws Exception {
        ServletInputStream stream = (ServletInputStream)PowerMock.createMock(ServletInputStream.class);
        EasyMock.expect((Object)this.request.getInputStream()).andReturn((Object)stream);
        ArrayList debuglogs = new ArrayList();
        EasyMock.expect((Object)this.jsonDebuglogMapper.map((InputStream)stream)).andReturn(debuglogs);
        PowerMock.replayAll((Object[])new Object[0]);
        this.debuglogServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testHandleRequestLogsEmpty() throws Exception {
        ServletInputStream stream = (ServletInputStream)PowerMock.createMock(ServletInputStream.class);
        EasyMock.expect((Object)this.request.getInputStream()).andReturn((Object)stream);
        ArrayList debuglogs = new ArrayList();
        EasyMock.expect((Object)this.jsonDebuglogMapper.map((InputStream)stream)).andReturn(debuglogs);
        PowerMock.replayAll((Object[])new Object[0]);
        this.debuglogServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }
}

