/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.servlet;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.PaymentService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.servlet.DatatransPaymentServlet;
import pl.smartapps.restserver.servlet.ServletUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={DatatransPaymentServlet.class, Mac.class, ServletUtils.class})
public class DatatransPaymentServletTests {
    private DatatransPaymentServlet paymentServlet;
    private PaymentService paymentService;
    private String sign2Key = "e68e8e82a9b4ba57985ea3210f5abdfffe85036c9d8e95f9b5e7c0206475f00fed8d89714a03814df7f2925367d276f8430dbed9f7dbf1843fff854e06e9d655";
    private String datatransId = "1100002405";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String sign2ResultInHex = "4c5db3b1379eafbf085b3763fc87b030";
    private String transactionId = "111220083347196307";
    private ParameterService parameterService;

    @Before
    public void setUp() {
        this.paymentServlet = new DatatransPaymentServlet();
        this.paymentService = (PaymentService)PowerMock.createMock(PaymentService.class);
        this.paymentServlet.setPaymentService(this.paymentService);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.paymentServlet.setParameterService(this.parameterService);
        this.request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        this.response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
    }

    @Test
    public void testProcessCorrectPaymentRequest() throws ServletException, IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidSessionException {
        EasyMock.expect((Object)this.request.getParameterMap()).andReturn((Object)this.preparePaymentParams("success")).times(8);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DATATRANS_MERCHANT_ID)).andReturn((Object)this.datatransId);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DATATRANS_SIGN2)).andReturn((Object)this.sign2Key);
        Mac mac = (Mac)PowerMock.createMock(Mac.class);
        PowerMock.mockStatic(Mac.class);
        EasyMock.expect((Object)Mac.getInstance("HmacMD5")).andReturn((Object)mac);
        mac.init((Key)EasyMock.isA(SecretKeySpec.class));
        EasyMock.expect((Object)mac.doFinal(EasyMock.aryEq((byte[])this.constructRawMessage()))).andReturn((Object)DatatransPaymentServletTests.hexStringToByteArray((String)this.sign2ResultInHex));
        PowerMock.mockStatic(ServletUtils.class);
        EasyMock.expect((Object)ServletUtils.toString((HttpServletRequest)this.request, (String)", ")).andReturn((Object)"raw_response");
        this.paymentService.processPaymentNotification("20111220083347000008", "success", "111220083347196307", "VIS", "raw_response");
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessTamperedPaymentRequest() throws ServletException, IOException, NoSuchAlgorithmException, InvalidKeyException {
        EasyMock.expect((Object)this.request.getParameterMap()).andReturn((Object)this.preparePaymentParams("success")).times(8);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DATATRANS_MERCHANT_ID)).andReturn((Object)this.datatransId);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DATATRANS_SIGN2)).andReturn((Object)this.sign2Key);
        Mac mac = (Mac)PowerMock.createMock(Mac.class);
        PowerMock.mockStatic(Mac.class);
        EasyMock.expect((Object)Mac.getInstance("HmacMD5")).andReturn((Object)mac);
        mac.init((Key)EasyMock.isA(SecretKeySpec.class));
        EasyMock.expect((Object)mac.doFinal(EasyMock.aryEq((byte[])this.constructRawMessage()))).andReturn((Object)DatatransPaymentServletTests.hexStringToByteArray((String)"4c5db3b1379eafbf085b3763fc"));
        PowerMock.mockStatic(ServletUtils.class);
        EasyMock.expect((Object)ServletUtils.toString((HttpServletRequest)this.request, (String)", ")).andReturn((Object)"raw_response");
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessIncorrectPaymentRequest() throws ServletException, IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidSessionException {
        EasyMock.expect((Object)this.request.getParameterMap()).andReturn((Object)this.preparePaymentParamsWithError("error", true)).times(8);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DATATRANS_MERCHANT_ID)).andReturn((Object)this.datatransId);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DATATRANS_SIGN2)).andReturn((Object)this.sign2Key);
        Mac mac = (Mac)PowerMock.createMock(Mac.class);
        PowerMock.mockStatic(Mac.class);
        EasyMock.expect((Object)Mac.getInstance("HmacMD5")).andReturn((Object)mac);
        mac.init((Key)EasyMock.isA(SecretKeySpec.class));
        EasyMock.expect((Object)mac.doFinal(EasyMock.aryEq((byte[])this.constructRawMessage()))).andReturn((Object)DatatransPaymentServletTests.hexStringToByteArray((String)this.sign2ResultInHex));
        PowerMock.mockStatic(ServletUtils.class);
        EasyMock.expect((Object)ServletUtils.toString((HttpServletRequest)this.request, (String)", ")).andReturn((Object)"raw_response");
        this.paymentService.processPaymentNotification("20111220083347000008", "000", "111220083347196307", null, "raw_response");
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    private Map<String, String[]> preparePaymentParams(String status) {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("AMOUNT", new String[]{"8280"});
        params.put("REFNO", new String[]{"20111220083347000008"});
        params.put("UPPTRANSACTIONID", new String[]{this.transactionId});
        params.put("sign2", new String[]{"4c5db3b1379eafbf085b3763fc87b030"});
        params.put("STATUS", new String[]{status});
        params.put("currency", new String[]{"CHF"});
        params.put("pmethod", new String[]{"VIS"});
        return params;
    }

    private Map<String, String[]> preparePaymentParamsWithError(String status, boolean sign2) {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("AMOUNT", new String[]{"8280"});
        params.put("REFNO", new String[]{"20111220083347000008"});
        params.put("UPPTRANSACTIONID", new String[]{this.transactionId});
        if (sign2) {
            params.put("sign2", new String[]{"4c5db3b1379eafbf085b3763fc87b030"});
        }
        params.put("STATUS", new String[]{status});
        params.put("currency", new String[]{"CHF"});
        params.put("errorCode", new String[]{"000"});
        return params;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    private byte[] constructRawMessage() {
        String rawMessage = "11000024058280CHF111220083347196307";
        System.out.println("test raw message: " + rawMessage.toString());
        return rawMessage.toString().getBytes();
    }
}

